/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProcessInstanceMarshaller;
import org.drools.marshalling.impl.ProcessMarshallerRegistry;
import org.drools.process.instance.impl.ProcessInstanceImpl;
import org.drools.runtime.process.ProcessInstance;
import org.hibernate.annotations.CollectionOfElements;

@Entity
public class ProcessInstanceInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long processInstanceId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String processId;
    private Date startDate;
    private Date lastReadDate;
    private Date lastModificationDate;
    private int state;
    @Lob
    private byte[] processInstanceByteArray;
    @CollectionOfElements
    private Set<String> eventTypes = new HashSet<String>();
    @Transient
    private ProcessInstance processInstance;

    ProcessInstanceInfo() {
    }

    public ProcessInstanceInfo(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.processId = processInstance.getProcessId();
        this.startDate = new Date();
    }

    public long getId() {
        return this.processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public Date getLastReadDate() {
        return this.lastReadDate;
    }

    public void updateLastReadDate() {
        this.lastReadDate = new Date();
    }

    public int getState() {
        return this.state;
    }

    public ProcessInstance getProcessInstance() {
        if (this.processInstance == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.processInstanceByteArray);
                MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, null, null, null);
                ProcessInstanceMarshaller marshaller = this.getMarshallerFromContext(context);
                this.processInstance = marshaller.readProcessInstance(context);
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException while loading process instance: " + e.getMessage());
            }
        }
        return this.processInstance;
    }

    private ProcessInstanceMarshaller getMarshallerFromContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        String processInstanceType = stream.readUTF();
        return ProcessMarshallerRegistry.INSTANCE.getMarshaller(processInstanceType);
    }

    private void saveProcessInstanceType(MarshallerWriteContext context, ProcessInstance processInstance, String processInstanceType) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeUTF(processInstanceType);
    }

    @PreUpdate
    public void update() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)baos, null, null, null, null);
            String processType = ((ProcessInstanceImpl)this.processInstance).getProcess().getType();
            this.saveProcessInstanceType(context, this.processInstance, processType);
            ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType);
            marshaller.writeProcessInstance(context, this.processInstance);
            context.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing process instance " + this.processInstance.getId() + ": " + e.getMessage());
        }
        byte[] newByteArray = baos.toByteArray();
        if (!Arrays.equals(newByteArray, this.processInstanceByteArray)) {
            this.state = this.processInstance.getState();
            this.lastModificationDate = new Date();
            this.processInstanceByteArray = newByteArray;
            this.eventTypes.clear();
            for (String type : this.processInstance.getEventTypes()) {
                this.eventTypes.add(type);
            }
        }
    }
}

