/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.Arrays;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.drools.persistence.session.JPASessionMarshallingHelper;

@Entity
public class SessionInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private Date startDate = new Date();
    private Date lastModificationDate;
    private boolean dirty;
    @Lob
    private byte[] rulesByteArray;
    @Transient
    private int versionShadow;
    @Transient
    private Date lastModificationDateShadow;
    @Transient
    private byte[] rulesByteArrayShadow;
    @Transient
    JPASessionMarshallingHelper helper;

    public int getId() {
        return this.id;
    }

    public void setJPASessionMashallingHelper(JPASessionMarshallingHelper helper) {
        this.helper = helper;
    }

    public byte[] getData() {
        return this.rulesByteArray;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setDirty() {
        this.dirty = true;
    }

    @PostLoad
    public void postLoad() {
        this.lastModificationDateShadow = this.lastModificationDate;
        this.rulesByteArrayShadow = this.rulesByteArray;
    }

    @PrePersist
    @PreUpdate
    public void update() {
        byte[] newByteArray = this.helper.getSnapshot();
        if (!Arrays.equals(newByteArray, this.rulesByteArray)) {
            this.lastModificationDate = new Date();
            this.rulesByteArray = newByteArray;
        }
        this.lastModificationDateShadow = this.lastModificationDate;
        this.rulesByteArrayShadow = this.rulesByteArray;
        this.dirty = false;
    }

    public void rollback() {
        this.dirty = false;
        this.lastModificationDate = this.lastModificationDateShadow;
        this.rulesByteArray = this.rulesByteArrayShadow;
    }
}

