/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance.persisters;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.drools.persistence.processinstance.persisters.VariablePersister;
import org.drools.persistence.processinstance.variabletypes.JPAPersistedVariable;
import org.drools.persistence.processinstance.variabletypes.VariableInstanceInfo;
import org.drools.runtime.Environment;

public class JPAVariablePersister
implements VariablePersister {
    public VariableInstanceInfo persistExternalVariable(String name, Object o, VariableInstanceInfo oldValue, Environment env) {
        if (o == null || oldValue != null && oldValue.getPersister().equals("")) {
            return null;
        }
        try {
            Serializable idValue;
            boolean newVariable = false;
            EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
            JPAPersistedVariable result = null;
            if (oldValue instanceof JPAPersistedVariable) {
                result = (JPAPersistedVariable)oldValue;
            }
            if (result == null) {
                result = new JPAPersistedVariable();
                newVariable = true;
            }
            if ((idValue = JPAVariablePersister.getClassIdValue(o)) != null) {
                System.out.println("Variable " + name + " -> Updating external Entity = " + o);
                em.merge(o);
            } else {
                System.out.println("Variable " + name + " -> Persisting external Entity for the first time =" + o);
                em.persist(o);
                idValue = JPAVariablePersister.getClassIdValue(o);
            }
            result.setPersister(this.getClass().getName());
            result.setName(name);
            result.setEntityId(idValue);
            result.setEntity(o);
            result.setEntityClass(o.getClass().getCanonicalName());
            if (newVariable) {
                em.persist((Object)result);
            } else {
                em.merge((Object)result);
            }
            System.out.println("Saving JPAPersistedVariable id=" + result.getId() + " entityId=" + result.getEntityId() + " class=" + result.getEntityClass() + " value=" + result.getEntity());
            return result;
        }
        catch (Throwable t) {
            Logger.getLogger(JPAVariablePersister.class.getName()).log(Level.SEVERE, null, t);
            throw new RuntimeException("Could not persist external variable", t);
        }
    }

    public Object getExternalPersistedVariable(VariableInstanceInfo variableInstanceInfo, Environment env) {
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        if ((JPAPersistedVariable)variableInstanceInfo == null || ((JPAPersistedVariable)variableInstanceInfo).getEntityId() == null) {
            return null;
        }
        System.out.println("Restoring JPAPersistedVariable id=" + ((JPAPersistedVariable)variableInstanceInfo).getId() + " entityId=" + ((JPAPersistedVariable)variableInstanceInfo).getEntityId() + " class=" + ((JPAPersistedVariable)variableInstanceInfo).getEntityClass() + " value=" + ((JPAPersistedVariable)variableInstanceInfo).getEntity());
        try {
            String varType = ((JPAPersistedVariable)variableInstanceInfo).getEntityClass();
            return em.find(Class.forName(varType), (Object)((JPAPersistedVariable)variableInstanceInfo).getEntityId());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JPAVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Could not restore external variable", ex);
        }
    }

    public static Serializable getClassIdValue(Object o) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        Id id;
        int i;
        Class<?> varClass = o.getClass();
        Serializable idValue = null;
        do {
            Field[] fields = varClass.getDeclaredFields();
            for (i = 0; i < fields.length && idValue == null; ++i) {
                Field field = fields[i];
                id = field.getAnnotation(Id.class);
                if (id == null) continue;
                try {
                    idValue = JPAVariablePersister.callIdMethod(o, "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    idValue = (Serializable)field.get(o);
                }
            }
        } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
        if (idValue == null) {
            varClass = o.getClass();
            do {
                Method[] methods = varClass.getMethods();
                for (i = 0; i < methods.length && idValue == null; ++i) {
                    Method method = methods[i];
                    id = method.getAnnotation(Id.class);
                    if (id == null) continue;
                    idValue = (Serializable)method.invoke(o, new Object[0]);
                }
            } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
        }
        return idValue;
    }

    private static Serializable callIdMethod(Object target, String methodName) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Serializable)target.getClass().getMethod(methodName, null).invoke(target, new Object[0]);
    }
}

