/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.collections.map.IdentityMap;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.command.CommandService;
import org.drools.command.Context;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.persistence.processinstance.JPAProcessInstanceManager;
import org.drools.persistence.processinstance.JPASignalManager;
import org.drools.persistence.processinstance.JPAWorkItemManager;
import org.drools.persistence.session.JPASessionMarshallingHelper;
import org.drools.persistence.session.SessionInfo;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSessionCommandService
implements CommandService {
    private EntityManagerFactory emf;
    private EntityManager em;
    private SessionInfo sessionInfo;
    private JPASessionMarshallingHelper marshallingHelper;
    private StatefulKnowledgeSession ksession;
    private Environment env;
    private KnowledgeCommandContext kContext;

    public void checkEnvironment(Environment env) {
        if (env.get("drools.persistence.jpa.EntityManagerFactory") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory");
        }
    }

    public SingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this((KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(int sessionId, RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this(sessionId, (KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.sessionInfo = new SessionInfo();
        ReteooStatefulSession session = (ReteooStatefulSession)((KnowledgeBaseImpl)kbase).ruleBase.newStatefulSession((SessionConfiguration)conf, this.env);
        this.ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)session, kbase);
        this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, this.ksession, null);
        ((JPASignalManager)((StatefulKnowledgeSessionImpl)this.ksession).session.getSignalManager()).setCommandService(this);
        this.marshallingHelper = new JPASessionMarshallingHelper(this.ksession, conf);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.em = this.emf.createEntityManager();
        boolean localTransaction = false;
        UserTransaction ut = null;
        try {
            InitialContext ctx = new InitialContext();
            ut = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                localTransaction = true;
            }
            this.registerRollbackSync();
            this.em.joinTransaction();
            this.em.persist((Object)this.sessionInfo);
            if (localTransaction) {
                ut.commit();
            }
        }
        catch (Throwable t1) {
            try {
                if (ut != null) {
                    ut.rollback();
                }
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not rollback transaction", t2);
            }
            throw new RuntimeException("Could not commit session", t1);
        }
        ((StatefulKnowledgeSessionImpl)this.ksession).session.setId(this.sessionInfo.getId());
    }

    public SingleSessionCommandService(int sessionId, KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.em = this.emf.createEntityManager();
        boolean localTransaction = false;
        UserTransaction ut = null;
        try {
            InitialContext ctx = new InitialContext();
            ut = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                localTransaction = true;
            }
            this.em.joinTransaction();
            this.registerRollbackSync();
            this.sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)sessionId);
            if (localTransaction) {
                ut.commit();
            }
        }
        catch (Throwable t1) {
            try {
                if (ut != null) {
                    ut.rollback();
                }
                throw new RuntimeException("Could not find session data for id " + sessionId, t1);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not rollback transaction", t2);
            }
        }
        if (this.sessionInfo == null) {
            throw new RuntimeException("Could not find session data for id " + sessionId);
        }
        this.marshallingHelper = new JPASessionMarshallingHelper(this.sessionInfo, kbase, conf, env);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.ksession = this.marshallingHelper.getObject();
        this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, this.ksession, null);
        ((JPASignalManager)((StatefulKnowledgeSessionImpl)this.ksession).session.getSignalManager()).setCommandService(this);
        ((StatefulKnowledgeSessionImpl)this.ksession).session.setId(this.sessionInfo.getId());
    }

    public Context getContext() {
        return this.kContext;
    }

    public synchronized <T> T execute(GenericCommand<T> command) {
        this.ksession.halt();
        boolean localTransaction = false;
        UserTransaction ut = null;
        try {
            EntityManager localEm;
            ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                localTransaction = true;
            }
            if ((localEm = (EntityManager)this.env.get("drools.persistence.jpa.EntityManager")) == null || !localEm.isOpen()) {
                localEm = this.emf.createEntityManager();
                this.env.set("drools.persistence.jpa.EntityManager", (Object)localEm);
            }
            if (this.em == null) {
                this.em = this.emf.createEntityManager();
                this.sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)this.sessionInfo.getId());
                this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
                this.marshallingHelper.loadSnapshot(this.sessionInfo.getData(), this.ksession);
            }
            this.em.joinTransaction();
            this.sessionInfo.setDirty();
            this.registerRollbackSync();
            Object result = command.execute((Context)this.kContext);
            if (localTransaction) {
                ut.commit();
                if (localEm.isOpen()) {
                    localEm.close();
                }
                this.env.set("drools.persistence.jpa.EntityManager", null);
                ((JPAProcessInstanceManager)((StatefulKnowledgeSessionImpl)this.ksession).session.getProcessInstanceManager()).clearProcessInstances();
                ((JPAWorkItemManager)((StatefulKnowledgeSessionImpl)this.ksession).session.getWorkItemManager()).clearWorkItems();
            }
            return (T)result;
        }
        catch (Throwable t1) {
            t1.printStackTrace();
            if (localTransaction) {
                try {
                    if (ut != null) {
                        ut.rollback();
                    }
                    throw new RuntimeException("Could not execute command", t1);
                }
                catch (Throwable t2) {
                    throw new RuntimeException("Could not rollback transaction", t2);
                }
            }
            throw new RuntimeException("Could not execute command", t1);
        }
    }

    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    public int getSessionId() {
        return this.sessionInfo.getId();
    }

    private void registerRollbackSync() throws IllegalStateException, RollbackException, SystemException {
        TransactionManager txm = (TransactionManager)this.env.get("drools.persistence.jpa.TransactionManager");
        if (txm == null) {
            return;
        }
        Map map = (Map)this.env.get("synchronizations");
        if (map == null) {
            map = new IdentityMap();
            this.env.set("synchronizations", (Object)map);
        }
        if (map.get(this) == null) {
            txm.getTransaction().registerSynchronization((Synchronization)new SynchronizationImpl());
            map.put(this, this);
        }
    }

    private void rollback() {
        this.em.close();
        this.em = null;
    }

    private class SynchronizationImpl
    implements Synchronization {
        private SynchronizationImpl() {
        }

        public void afterCompletion(int status) {
            if (status != 3) {
                SingleSessionCommandService.this.rollback();
            }
            Map map = (Map)SingleSessionCommandService.this.env.get("synchronizations");
            map.remove(SingleSessionCommandService.this);
            EntityManager localEm = (EntityManager)SingleSessionCommandService.this.env.get("drools.persistence.jpa.EntityManager");
            if (localEm != null && localEm.isOpen()) {
                localEm.close();
            }
            SingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", null);
            if (SingleSessionCommandService.this.ksession != null) {
                ((JPAProcessInstanceManager)((StatefulKnowledgeSessionImpl)((SingleSessionCommandService)SingleSessionCommandService.this).ksession).session.getProcessInstanceManager()).clearProcessInstances();
                ((JPAWorkItemManager)((StatefulKnowledgeSessionImpl)((SingleSessionCommandService)SingleSessionCommandService.this).ksession).session.getWorkItemManager()).clearWorkItems();
            }
        }

        public void beforeCompletion() {
        }
    }
}

