/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.persistence.processinstance.ProcessInstanceInfo;
import org.drools.process.core.Process;
import org.drools.process.instance.ProcessInstanceManager;
import org.drools.process.instance.impl.ProcessInstanceImpl;
import org.drools.runtime.process.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAProcessInstanceManager
implements ProcessInstanceManager {
    private WorkingMemory workingMemory;
    private transient Map<Long, org.drools.process.instance.ProcessInstance> processInstances;

    public void setWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void addProcessInstance(org.drools.process.instance.ProcessInstance processInstance) {
        ProcessInstanceInfo processInstanceInfo = new ProcessInstanceInfo((ProcessInstance)processInstance, this.workingMemory.getEnvironment());
        EntityManager em = (EntityManager)this.workingMemory.getEnvironment().get("drools.persistence.jpa.EntityManager");
        em.persist((Object)processInstanceInfo);
        processInstance.setId(processInstanceInfo.getId());
        processInstanceInfo.updateLastReadDate();
        this.internalAddProcessInstance(processInstance);
    }

    public void internalAddProcessInstance(org.drools.process.instance.ProcessInstance processInstance) {
        if (this.processInstances == null) {
            this.processInstances = new HashMap<Long, org.drools.process.instance.ProcessInstance>();
        }
        this.processInstances.put(processInstance.getId(), processInstance);
    }

    public org.drools.process.instance.ProcessInstance getProcessInstance(long id) {
        org.drools.process.instance.ProcessInstance processInstance = null;
        if (this.processInstances != null && (processInstance = this.processInstances.get(id)) != null) {
            return processInstance;
        }
        EntityManager em = (EntityManager)this.workingMemory.getEnvironment().get("drools.persistence.jpa.EntityManager");
        ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)em.find(ProcessInstanceInfo.class, (Object)id);
        if (processInstanceInfo == null) {
            return null;
        }
        processInstanceInfo.updateLastReadDate();
        processInstance = (org.drools.process.instance.ProcessInstance)processInstanceInfo.getProcessInstance(this.workingMemory, this.workingMemory.getEnvironment());
        Process process = ((InternalRuleBase)this.workingMemory.getRuleBase()).getProcess(processInstance.getProcessId());
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processInstance.getProcessId());
        }
        processInstance.setProcess((org.drools.definition.process.Process)process);
        if (processInstance.getWorkingMemory() == null) {
            processInstance.setWorkingMemory((InternalWorkingMemory)this.workingMemory);
            ((ProcessInstanceImpl)processInstance).reconnect();
        }
        return processInstance;
    }

    public Collection<org.drools.process.instance.ProcessInstance> getProcessInstances() {
        return new ArrayList<org.drools.process.instance.ProcessInstance>();
    }

    public void removeProcessInstance(org.drools.process.instance.ProcessInstance processInstance) {
        EntityManager em = (EntityManager)this.workingMemory.getEnvironment().get("drools.persistence.jpa.EntityManager");
        ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)em.find(ProcessInstanceInfo.class, (Object)processInstance.getId());
        if (processInstanceInfo != null) {
            em.remove((Object)processInstanceInfo);
        }
        this.internalRemoveProcessInstance(processInstance);
    }

    public void internalRemoveProcessInstance(org.drools.process.instance.ProcessInstance processInstance) {
        if (this.processInstances != null) {
            this.processInstances.remove(processInstance.getId());
        }
    }

    public void clearProcessInstances() {
        if (this.processInstances != null) {
            for (org.drools.process.instance.ProcessInstance processInstance : new ArrayList<org.drools.process.instance.ProcessInstance>(this.processInstances.values())) {
                ((ProcessInstanceImpl)processInstance).disconnect();
            }
        }
    }
}

