/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProcessInstanceMarshaller;
import org.drools.marshalling.impl.ProcessMarshallerRegistry;
import org.drools.persistence.processinstance.VariablePersistenceStrategy;
import org.drools.persistence.processinstance.VariablePersistenceStrategyFactory;
import org.drools.persistence.processinstance.variabletypes.VariableInstanceInfo;
import org.drools.process.instance.ContextInstance;
import org.drools.process.instance.ContextInstanceContainer;
import org.drools.process.instance.ContextableInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.impl.ProcessInstanceImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.hibernate.annotations.CollectionOfElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ProcessInstanceInfo {
    private static final String VARIABLE_SEPARATOR = ":";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="InstanceId")
    private Long processInstanceId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String processId;
    private Date startDate;
    private Date lastReadDate;
    private Date lastModificationDate;
    private int state;
    @Lob
    private byte[] processInstanceByteArray;
    @CollectionOfElements
    @JoinTable(name="EventTypes", joinColumns={@JoinColumn(name="InstanceId")})
    private Set<String> eventTypes = new HashSet<String>();
    @Transient
    private ProcessInstance processInstance;
    @Transient
    private Environment env;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="processInstanceId")
    @MapKey(name="name")
    private Map<String, VariableInstanceInfo> variables = new HashMap<String, VariableInstanceInfo>();
    private boolean externalVariables = false;

    protected ProcessInstanceInfo() {
    }

    public ProcessInstanceInfo(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.processId = processInstance.getProcessId();
        this.startDate = new Date();
    }

    public ProcessInstanceInfo(ProcessInstance processInstance, Environment env) {
        this.processInstance = processInstance;
        this.processId = processInstance.getProcessId();
        this.startDate = new Date();
        this.env = env;
    }

    public long getId() {
        return this.processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public Date getLastReadDate() {
        return this.lastReadDate;
    }

    public void updateLastReadDate() {
        this.lastReadDate = new Date();
    }

    public int getState() {
        return this.state;
    }

    public ProcessInstance getProcessInstance(WorkingMemory workingMemory, Environment env) {
        this.env = env;
        if (this.processInstance == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.processInstanceByteArray);
                MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, (InternalRuleBase)workingMemory.getRuleBase(), null, null);
                context.wm = (InternalWorkingMemory)workingMemory;
                ProcessInstanceMarshaller marshaller = this.getMarshallerFromContext(context);
                this.processInstance = marshaller.readProcessInstance(context, !this.externalVariables);
                if (this.externalVariables) {
                    this.restoreVariables();
                }
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException while loading process instance: " + e.getMessage(), e);
            }
        }
        return this.processInstance;
    }

    private void restoreVariables() {
        for (Map.Entry<String, VariableInstanceInfo> entry : this.variables.entrySet()) {
            String[] variableHierarchy = entry.getKey().split(VARIABLE_SEPARATOR);
            String variableName = variableHierarchy[variableHierarchy.length - 1];
            ArrayList<Long> parentIds = new ArrayList<Long>();
            int i = 0;
            while (i < variableHierarchy.length - 1) {
                parentIds.add(Long.valueOf(variableHierarchy[i]));
                ++i;
            }
            this.restoreVariable(entry.getValue(), parentIds, variableName, (NodeInstanceContainer)((WorkflowProcessInstance)this.processInstance));
        }
    }

    private void restoreVariable(VariableInstanceInfo variableInfo, List<Long> parentIds, String variableName, NodeInstanceContainer nodeInstanceContainer) throws NumberFormatException {
        if (parentIds.size() == 0) {
            if (!(nodeInstanceContainer instanceof ContextableInstance)) {
                throw new IllegalArgumentException("Parent node instance is not a contextable instance: " + nodeInstanceContainer);
            }
        } else {
            Long nodeInstanceId = parentIds.get(0);
            Collection nodeInstances = nodeInstanceContainer.getNodeInstances();
            Iterator iterator = nodeInstances.iterator();
            if (iterator.hasNext()) {
                NodeInstance nodeInstance = (NodeInstance)iterator.next();
                if (nodeInstance.getId() == nodeInstanceId.longValue()) {
                    parentIds.remove(0);
                    if (!(nodeInstance instanceof NodeInstanceContainer)) {
                        throw new IllegalArgumentException("Restoring variable " + variableName + " but node found is not a node instance container:" + nodeInstance);
                    }
                    this.restoreVariable(variableInfo, parentIds, variableName, (NodeInstanceContainer)nodeInstance);
                }
                return;
            }
            throw new IllegalArgumentException("Could not find node instance " + nodeInstanceId + " in " + nodeInstanceContainer);
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ContextableInstance)nodeInstanceContainer).getContextInstance("VariableScope");
        VariablePersistenceStrategy persistenceStrategy = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy();
        Object value = persistenceStrategy.getVariable(variableInfo, this.env);
        System.out.println(">>>>> Restoring variable " + variableName + " = " + value);
        variableScopeInstance.setVariable(variableName, value);
    }

    private ProcessInstanceMarshaller getMarshallerFromContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        String processInstanceType = stream.readUTF();
        return ProcessMarshallerRegistry.INSTANCE.getMarshaller(processInstanceType);
    }

    private void saveProcessInstanceType(MarshallerWriteContext context, ProcessInstance processInstance, String processInstanceType) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeUTF(processInstanceType);
    }

    @PreUpdate
    public void update() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean variablesChanged = false;
        try {
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)baos, null, null, null, null);
            String processType = ((ProcessInstanceImpl)this.processInstance).getProcess().getType();
            this.saveProcessInstanceType(context, this.processInstance, processType);
            ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType);
            this.externalVariables = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy().isEnabled();
            marshaller.writeProcessInstance(context, this.processInstance, !this.externalVariables);
            if (this.externalVariables) {
                variablesChanged = this.persistVariables();
            }
            context.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing process instance " + this.processInstance.getId() + ": " + e.getMessage());
        }
        byte[] newByteArray = baos.toByteArray();
        if (variablesChanged || !Arrays.equals(newByteArray, this.processInstanceByteArray)) {
            this.state = this.processInstance.getState();
            this.lastModificationDate = new Date();
            this.processInstanceByteArray = newByteArray;
            this.eventTypes.clear();
            String[] stringArray = this.processInstance.getEventTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.eventTypes.add(type);
                ++n2;
            }
        }
    }

    private boolean persistVariables() {
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((WorkflowProcessInstanceImpl)this.processInstance).getContextInstance("VariableScope");
        Map processVariables = variableScopeInstance.getVariables();
        HashMap<String, VariableInstanceInfo> newVariables = new HashMap<String, VariableInstanceInfo>();
        this.persist(processVariables, "", newVariables);
        Collection nodeInstances = ((WorkflowProcessInstanceImpl)this.processInstance).getNodeInstances();
        if (nodeInstances.size() > 0) {
            this.persistNodeVariables(nodeInstances, "", newVariables);
        }
        if (newVariables.size() > 0 || this.variables.size() > 0) {
            this.variables.clear();
            this.variables.putAll(newVariables);
            return true;
        }
        return false;
    }

    private void persist(Map<String, Object> variables, String prefix, Map<String, VariableInstanceInfo> newVariables) {
        VariablePersistenceStrategy persistenceStrategy = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy();
        for (Map.Entry<String, Object> entries : variables.entrySet()) {
            VariableInstanceInfo oldValue;
            Object value;
            String variableName = String.valueOf(prefix) + entries.getKey();
            VariableInstanceInfo variable = persistenceStrategy.persistVariable(variableName, value = entries.getValue(), oldValue = this.variables.get(variableName), this.env);
            if (variable != null) {
                System.out.println("<<<<< Persisting variable " + variableName + " = " + value);
                newVariables.put(variableName, variable);
                continue;
            }
            System.out.println("<<<<< Variable " + variableName + " not persisted (value null)");
        }
    }

    private void persistNodeVariables(Collection<NodeInstance> nodeInstances, String parentPrefix, Map<String, VariableInstanceInfo> newVariables) {
        for (NodeInstance nodeInstance : nodeInstances) {
            List variableScopeInstances;
            String prefix = String.valueOf(parentPrefix) + nodeInstance.getId() + VARIABLE_SEPARATOR;
            if (nodeInstance instanceof ContextInstanceContainer && (variableScopeInstances = ((ContextInstanceContainer)nodeInstance).getContextInstances("VariableScope")) != null) {
                for (ContextInstance contextInstance : variableScopeInstances) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)contextInstance;
                    this.persist(variableScopeInstance.getVariables(), prefix, newVariables);
                }
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            Collection nodeInstancesInsideTheContainer = ((NodeInstanceContainer)nodeInstance).getNodeInstances();
            this.persistNodeVariables(nodeInstancesInsideTheContainer, prefix, newVariables);
        }
    }

    public Map<String, VariableInstanceInfo> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableInstanceInfo> variables) {
        this.variables = variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceInfo other = (ProcessInstanceInfo)obj;
        if (!(this.processInstanceId == other.processInstanceId || this.processInstanceId != null && this.processInstanceId.equals(other.processInstanceId))) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (!(this.startDate == other.startDate || this.startDate != null && this.startDate.equals(other.startDate))) {
            return false;
        }
        if (!(this.lastReadDate == other.lastReadDate || this.lastReadDate != null && this.lastReadDate.equals(other.lastReadDate))) {
            return false;
        }
        if (!(this.lastModificationDate == other.lastModificationDate || this.lastModificationDate != null && this.lastModificationDate.equals(other.lastModificationDate))) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (!Arrays.equals(this.processInstanceByteArray, other.processInstanceByteArray)) {
            return false;
        }
        if (!(this.eventTypes == other.eventTypes || this.eventTypes != null && this.eventTypes.equals(other.eventTypes))) {
            return false;
        }
        if (!(this.processInstance == other.processInstance || this.processInstance != null && this.processInstance.equals(other.processInstance))) {
            return false;
        }
        if (!(this.env == other.env || this.env != null && this.env.equals(other.env))) {
            return false;
        }
        return this.variables == other.variables || this.variables != null && this.variables.equals(other.variables);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.processInstanceId != null ? this.processInstanceId.hashCode() : 0);
        hash = 61 * hash + this.version;
        hash = 61 * hash + (this.processId != null ? this.processId.hashCode() : 0);
        hash = 61 * hash + (this.startDate != null ? this.startDate.hashCode() : 0);
        hash = 61 * hash + (this.lastReadDate != null ? this.lastReadDate.hashCode() : 0);
        hash = 61 * hash + (this.lastModificationDate != null ? this.lastModificationDate.hashCode() : 0);
        hash = 61 * hash + this.state;
        hash = 61 * hash + Arrays.hashCode(this.processInstanceByteArray);
        hash = 61 * hash + (this.eventTypes != null ? this.eventTypes.hashCode() : 0);
        hash = 61 * hash + (this.processInstance != null ? this.processInstance.hashCode() : 0);
        hash = 61 * hash + (this.env != null ? this.env.hashCode() : 0);
        hash = 61 * hash + (this.variables != null ? this.variables.hashCode() : 0);
        return hash;
    }
}

