/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.persistence.processinstance.persisters.VariablePersister;
import org.drools.persistence.processinstance.variabletypes.VariableInstanceInfo;
import org.drools.runtime.Environment;

public class VariablePersistenceStrategy {
    private Map<String, String> types = new HashMap<String, String>();
    private Map<String, VariablePersister> variablePersisters = new HashMap<String, VariablePersister>();

    public void setPersister(String type, String persisterClassname) {
        this.types.put(type, persisterClassname);
    }

    public boolean isEnabled() {
        return !this.types.isEmpty();
    }

    public VariableInstanceInfo persistVariable(String name, Object o, VariableInstanceInfo oldValue, Environment env) {
        VariablePersister persister = this.getVariablePersister(o);
        VariableInstanceInfo variable = null;
        if (persister != null) {
            variable = persister.persistExternalVariable(name, o, oldValue, env);
        }
        return variable;
    }

    private VariablePersister getVariablePersister(Object o) {
        VariablePersister persister = null;
        String persisterFQN = this.getVariablePersistenceType(o);
        if (persisterFQN != null && !persisterFQN.equals("")) {
            Class<?> persisterClass = null;
            persister = this.variablePersisters.get(persisterFQN);
            if (persister != null) {
                return persister;
            }
            try {
                persisterClass = Class.forName(persisterFQN);
                Constructor<?> constructor = persisterClass.getConstructor(new Class[0]);
                persister = (VariablePersister)constructor.newInstance(new Object[0]);
                this.variablePersisters.put(persisterFQN, persister);
                return persister;
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public Object getVariable(VariableInstanceInfo variableInfo, Environment env) {
        try {
            String persisterFQN = variableInfo.getPersister();
            VariablePersister persister = this.variablePersisters.get(persisterFQN);
            if (persister == null) {
                Class<?> clazz = Class.forName(persisterFQN);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                persister = (VariablePersister)constructor.newInstance(new Object[0]);
                this.variablePersisters.put(persisterFQN, persister);
            }
            return persister.getExternalPersistedVariable(variableInfo, env);
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            Logger.getLogger(VariablePersistenceStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private String getVariablePersistenceType(Object o) {
        Class<?>[] interfaces;
        int n;
        if (o == null) {
            return null;
        }
        String className = o.getClass().getCanonicalName();
        String persisterFQN = this.types.get(className);
        if (persisterFQN != null && !persisterFQN.equals("")) {
            return persisterFQN;
        }
        Annotation[] annotations = o.getClass().getDeclaredAnnotations();
        if (annotations != null) {
            Annotation[] annotationArray = annotations;
            n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                persisterFQN = this.types.get(annotation.annotationType().getName());
                if (persisterFQN != null && !persisterFQN.equals("")) {
                    return persisterFQN;
                }
                ++n2;
            }
        }
        if ((interfaces = o.getClass().getInterfaces()) != null) {
            Class<?>[] classArray = interfaces;
            int n3 = interfaces.length;
            n = 0;
            while (n < n3) {
                Class<?> clazz = classArray[n];
                persisterFQN = this.types.get(clazz.getName());
                if (persisterFQN != null && !persisterFQN.equals("")) {
                    return persisterFQN;
                }
                ++n;
            }
        }
        return null;
    }
}

