/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance.persisters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.drools.persistence.processinstance.persisters.JPAVariablePersister;
import org.drools.persistence.processinstance.persisters.VariablePersister;
import org.drools.persistence.processinstance.variabletypes.SerializablePersistedVariable;
import org.drools.persistence.processinstance.variabletypes.VariableInstanceInfo;
import org.drools.runtime.Environment;

public class SerializableVariablePersister
implements VariablePersister {
    public VariableInstanceInfo persistExternalVariable(String name, Object o, VariableInstanceInfo oldValue, Environment env) {
        boolean newVariable = false;
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.EntityManager");
        SerializablePersistedVariable result = null;
        if (o == null || oldValue != null && oldValue.getPersister().equals("")) {
            return null;
        }
        if (oldValue instanceof SerializablePersistedVariable) {
            result = (SerializablePersistedVariable)oldValue;
        }
        if (result == null) {
            result = new SerializablePersistedVariable();
            newVariable = true;
        }
        result.setPersister(this.getClass().getName());
        result.setName(name);
        result.setContent(this.getBytes(o));
        if (newVariable) {
            em.persist((Object)result);
        } else {
            em.merge((Object)result);
        }
        return result;
    }

    public Object getExternalPersistedVariable(VariableInstanceInfo variableInstanceInfo, Environment env) {
        ObjectInputStream ois = null;
        byte[] binaryArray = null;
        if ((SerializablePersistedVariable)variableInstanceInfo == null || ((SerializablePersistedVariable)variableInstanceInfo).getContent() == null) {
            return null;
        }
        try {
            binaryArray = ((SerializablePersistedVariable)variableInstanceInfo).getContent();
            if (binaryArray == null) {
                return null;
            }
            ByteArrayInputStream strmBytes = new ByteArrayInputStream(binaryArray);
            ois = new ObjectInputStream(strmBytes);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException ex) {
            Logger.getLogger(SerializableVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JPAVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SerializableVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private byte[] getBytes(Object o) {
        ObjectOutputStream oos = null;
        try {
            byte[] data;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            bos.close();
            byte[] byArray = data = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            Logger.getLogger(SerializableVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SerializableVariablePersister.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }
}

