/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.session.JpaManager;
import org.drools.runtime.Environment;

public class DefaultJpaManager
implements JpaManager {
    Environment env;
    private EntityManagerFactory emf;
    private EntityManager appScopedEntityManager;
    private EntityManager cmdScopedEntityManager;
    private boolean internalAppScopedEntityManager;
    private boolean internalCmdScopedEntityManager;

    public DefaultJpaManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
    }

    public EntityManager getApplicationScopedEntityManager() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                this.internalAppScopedEntityManager = true;
                this.appScopedEntityManager = this.emf.createEntityManager();
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
            } else {
                this.internalAppScopedEntityManager = false;
            }
        }
        return this.appScopedEntityManager;
    }

    public EntityManager getCommandScopedEntityManager() {
        return this.cmdScopedEntityManager;
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.CmdScopedEntityManager");
        if (cmdScopedEntityManager == null || !cmdScopedEntityManager.isOpen()) {
            this.internalCmdScopedEntityManager = true;
            cmdScopedEntityManager = this.emf.createEntityManager();
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", (Object)cmdScopedEntityManager);
        } else {
            this.internalCmdScopedEntityManager = false;
        }
        cmdScopedEntityManager.joinTransaction();
        this.appScopedEntityManager.joinTransaction();
    }

    public void endCommandScopedEntityManager() {
        if (this.internalCmdScopedEntityManager) {
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
        }
    }

    public void dispose() {
        if (this.internalAppScopedEntityManager) {
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
            }
            this.internalAppScopedEntityManager = false;
            this.env.set("drools.persistence.jpa.AppScopedEntityManager", null);
        }
        if (this.internalCmdScopedEntityManager) {
            if (this.cmdScopedEntityManager != null && this.cmdScopedEntityManager.isOpen()) {
                this.cmdScopedEntityManager.close();
            }
            this.internalCmdScopedEntityManager = false;
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
        }
    }
}

