/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedPersistenceContext
implements PersistenceContext,
NonTransactionalPersistentSession {
    private Map<Integer, SessionInfo> ksessions;
    private Map<Long, WorkItemInfo> workItems;
    private boolean open = true;
    private KnowledgeSessionStorage storage;

    public MapBasedPersistenceContext(KnowledgeSessionStorage storage) {
        this.storage = storage;
        this.ksessions = new HashMap<Integer, SessionInfo>();
        this.workItems = new HashMap<Long, WorkItemInfo>();
    }

    @Override
    public void persist(SessionInfo entity) {
        if (entity.getId() == null) {
            entity.setId(this.storage.getNextStatefulKnowledgeSessionId());
        }
        this.ksessions.put(entity.getId(), entity);
    }

    @Override
    public SessionInfo findSessionInfo(Integer sessionId) {
        SessionInfo sessionInfo = this.ksessions.get(sessionId);
        if (sessionInfo == null) {
            sessionInfo = this.storage.findSessionInfo(sessionId);
            this.ksessions.put(sessionId, sessionInfo);
        }
        return sessionInfo;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void joinTransaction() {
    }

    @Override
    public void close() {
        this.open = false;
        this.clear();
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    private void clearAll() {
        this.ksessions.clear();
        this.workItems.clear();
    }

    @Override
    public List<SessionInfo> getStoredKnowledgeSessions() {
        return Collections.unmodifiableList(new ArrayList<SessionInfo>(this.ksessions.values()));
    }

    @Override
    public void persist(WorkItemInfo workItemInfo) {
        if (workItemInfo.getId() == null) {
            workItemInfo.setId(this.storage.getNextWorkItemId());
        }
        this.workItems.put(workItemInfo.getId(), workItemInfo);
    }

    @Override
    public List<WorkItemInfo> getStoredWorkItems() {
        return Collections.unmodifiableList(new ArrayList<WorkItemInfo>(this.workItems.values()));
    }

    @Override
    public WorkItemInfo findWorkItemInfo(Long id) {
        WorkItemInfo workItemInfo = this.workItems.get(id);
        if (workItemInfo == null) {
            workItemInfo = this.storage.findWorkItemInfo(id);
        }
        return workItemInfo;
    }

    @Override
    public void remove(WorkItemInfo workItemInfo) {
        if (this.workItems.remove(workItemInfo.getId()) != null) {
            this.storage.remove(workItemInfo);
        }
    }

    @Override
    public WorkItemInfo merge(WorkItemInfo workItemInfo) {
        return workItemInfo;
    }
}

