/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.KnowledgeBase;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;

public class SessionMarshallingHelper {
    private KnowledgeBase kbase;
    private KnowledgeSessionConfiguration conf;
    private StatefulKnowledgeSession ksession;
    private Marshaller marshaller;
    private Environment env;

    public SessionMarshallingHelper(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        this.kbase = kbase;
        this.conf = conf;
        this.env = env;
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])env.get("drools.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? MarshallerFactory.newMarshaller((KnowledgeBase)kbase, (ObjectMarshallingStrategy[])strategies) : MarshallerFactory.newMarshaller((KnowledgeBase)kbase);
    }

    public SessionMarshallingHelper(StatefulKnowledgeSession ksession, KnowledgeSessionConfiguration conf) {
        this.ksession = ksession;
        this.kbase = ksession.getKnowledgeBase();
        this.conf = conf;
        this.env = ksession.getEnvironment();
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])this.env.get("drools.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? MarshallerFactory.newMarshaller((KnowledgeBase)this.kbase, (ObjectMarshallingStrategy[])strategies) : MarshallerFactory.newMarshaller((KnowledgeBase)this.kbase);
    }

    public byte[] getSnapshot() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.marshaller.marshall((OutputStream)baos, this.ksession);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get session snapshot", e);
        }
        return baos.toByteArray();
    }

    public StatefulKnowledgeSession loadSnapshot(byte[] bytes, StatefulKnowledgeSession ksession) {
        this.ksession = ksession;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            if (this.ksession != null) {
                this.marshaller.unmarshall((InputStream)bais, this.ksession);
            } else {
                this.ksession = this.marshaller.unmarshall((InputStream)bais, this.conf, this.env);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load session snapshot", e);
        }
        return this.ksession;
    }

    public StatefulKnowledgeSession getObject() {
        return this.ksession;
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public KnowledgeSessionConfiguration getConf() {
        return this.conf;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }
}

