/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.command.Command;
import org.drools.command.CommandService;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.persistence.jpa.JpaTimerJobInstance;
import org.drools.time.InternalSchedulerService;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SelfRemovalJob;
import org.drools.time.SelfRemovalJobContext;
import org.drools.time.Trigger;
import org.drools.time.impl.DefaultTimerJobInstance;
import org.drools.time.impl.JDKTimerService;
import org.drools.time.impl.TimerJobInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaJDKTimerService
extends JDKTimerService {
    private static Logger logger = LoggerFactory.getLogger(JpaTimerJobInstance.class);
    private CommandService commandService;
    private Map<Long, TimerJobInstance> timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public JpaJDKTimerService() {
        this(1);
        this.timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();
    }

    public JpaJDKTimerService(int size) {
        super(size);
    }

    protected Callable<Void> createCallableJob(Job job, JobContext ctx, Trigger trigger, JDKTimerService.JDKJobHandle handle, InternalSchedulerService scheduler) {
        JpaJDKCallableJob jobInstance = new JpaJDKCallableJob((Job)new SelfRemovalJob(job), (JobContext)new SelfRemovalJobContext(ctx, this.timerInstances), trigger, handle, scheduler);
        this.timerInstances.put(handle.getId(), (TimerJobInstance)jobInstance);
        return jobInstance;
    }

    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.timerInstances.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JDKCallableJobCommand
    implements GenericCommand<Void> {
        private static final long serialVersionUID = 4L;
        private JpaJDKCallableJob job;

        public JDKCallableJobCommand(JpaJDKCallableJob job) {
            this.job = job;
        }

        public Void execute(Context context) {
            try {
                return this.job.internalCall();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public class JpaJDKCallableJob
    extends DefaultTimerJobInstance {
        public JpaJDKCallableJob(Job job, JobContext ctx, Trigger trigger, JDKTimerService.JDKJobHandle handle, InternalSchedulerService scheduler) {
            super(job, ctx, trigger, (JobHandle)handle, scheduler);
        }

        public Void call() throws Exception {
            try {
                JDKCallableJobCommand command = new JDKCallableJobCommand(this);
                JpaJDKTimerService.this.commandService.execute((Command)command);
            }
            catch (Exception e) {
                logger.error("Unable to execute job!", (Throwable)e);
                throw e;
            }
            return null;
        }

        private Void internalCall() throws Exception {
            return super.call();
        }
    }
}

