/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.marshalling.Marshaller;
import org.kie.marshalling.MarshallerFactory;
import org.kie.marshalling.ObjectMarshallingStrategy;
import org.kie.runtime.Environment;
import org.kie.runtime.KieSession;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.StatefulKnowledgeSession;

public class SessionMarshallingHelper {
    private KnowledgeBase kbase;
    private KieSessionConfiguration conf;
    private KieSession ksession;
    private Marshaller marshaller;
    private Environment env;

    public SessionMarshallingHelper(KnowledgeBase kbase, KieSessionConfiguration conf, Environment env) {
        this.kbase = kbase;
        this.conf = conf;
        this.env = env;
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])env.get("org.kie.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? MarshallerFactory.newMarshaller((KieBase)kbase, (ObjectMarshallingStrategy[])strategies) : MarshallerFactory.newMarshaller((KieBase)kbase);
    }

    public SessionMarshallingHelper(StatefulKnowledgeSession ksession, KieSessionConfiguration conf) {
        this.ksession = ksession;
        this.kbase = ksession.getKieBase();
        this.conf = conf;
        this.env = ksession.getEnvironment();
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])this.env.get("org.kie.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? MarshallerFactory.newMarshaller((KieBase)this.kbase, (ObjectMarshallingStrategy[])strategies) : MarshallerFactory.newMarshaller((KieBase)this.kbase);
    }

    public byte[] getSnapshot() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.marshaller.marshall((OutputStream)baos, this.ksession);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get session snapshot", e);
        }
        return baos.toByteArray();
    }

    public KieSession loadSnapshot(byte[] bytes, KieSession ksession) {
        this.ksession = ksession;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            if (this.ksession != null) {
                this.marshaller.unmarshall((InputStream)bais, this.ksession);
            } else {
                this.ksession = this.marshaller.unmarshall((InputStream)bais, this.conf, this.env);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load session snapshot", e);
        }
        return this.ksession;
    }

    public KieSession getObject() {
        return this.ksession;
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public KieSessionConfiguration getConf() {
        return this.conf;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }
}

