/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLockInterceptor
extends AbstractInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLockInterceptor.class);
    private boolean active = false;
    private ReentrantLock lock = new ReentrantLock();
    private Environment environment;
    private String releaseTxKey;
    private Set<Long> forceUnlock = new CopyOnWriteArraySet<Long>();

    public TransactionLockInterceptor(Environment environment) {
        this(environment, "tx-unlock");
    }

    public TransactionLockInterceptor(Environment environment, String releaseTxKey) {
        this.environment = environment;
        this.releaseTxKey = releaseTxKey;
        this.active = Boolean.getBoolean("org.kie.tx.lock.enabled");
        if (environment.get("TRANSACTION_LOCK_ENABLED") != null) {
            this.active = Boolean.parseBoolean(environment.get("TRANSACTION_LOCK_ENABLED").toString());
        }
        logger.debug("Transaction lock interceptor enabled " + this.active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        if (!this.active) {
            return (T)this.executeNext(command);
        }
        this.releaseAfterFailure();
        boolean locked = false;
        if (!this.lock.isHeldByCurrentThread()) {
            logger.debug("About to get a lock on command service by {}", (Object)Thread.currentThread().getName());
            this.lock.lock();
            locked = true;
            logger.debug("Lock taken by {}", (Object)Thread.currentThread().getName());
        }
        try {
            Object object = this.executeNext(command);
            return (T)object;
        }
        finally {
            if (locked) {
                logger.debug("About to register lock release handler by {}", (Object)Thread.currentThread().getName());
                this.release((TransactionManager)this.environment.get("org.kie.transaction.TransactionManager"));
            }
            this.releaseAfterFailure();
        }
    }

    protected void release(TransactionManager txm) {
        try {
            TransactionManagerHelper.registerTransactionSyncInContainer(txm, new ReleaseLockTransactionSynchronization(Thread.currentThread().getId(), 100, this.releaseTxKey));
        }
        catch (Throwable e) {
            logger.debug("Error happened releasing directly by {} due to {}", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
            this.doRelease();
        }
    }

    protected void releaseAfterFailure() {
        if (this.forceUnlock.remove(Thread.currentThread().getId())) {
            logger.debug("Forcibly unlocking as it was requested by a reaper thread (transaction timeout)");
            this.doRelease();
        }
    }

    protected void doRelease() {
        logger.debug("Releasing on transaction completion by {}", (Object)Thread.currentThread().getName());
        this.lock.unlock();
        logger.debug("Successfully released lock by {}", (Object)Thread.currentThread().getName());
    }

    private class ReleaseLockTransactionSynchronization
    extends OrderedTransactionSynchronization {
        private volatile long registrationThreadId;

        public ReleaseLockTransactionSynchronization(long threadId, Integer order, String identifier) {
            super(order, identifier);
            this.registrationThreadId = threadId;
        }

        @Override
        public void beforeCompletion() {
        }

        @Override
        public void afterCompletion(int status) {
            if (this.isRollback(status)) {
                boolean isRegistrationThread;
                long currentThreadId = Thread.currentThread().getId();
                boolean bl = isRegistrationThread = currentThreadId == this.registrationThreadId;
                if (!isRegistrationThread) {
                    logger.debug("Attempt to unlock from different thread {} while owner is {}, requesting force unlock", (Object)currentThreadId, (Object)this.registrationThreadId);
                    TransactionLockInterceptor.this.forceUnlock.add(this.registrationThreadId);
                    return;
                }
            }
            TransactionLockInterceptor.this.doRelease();
        }

        boolean isRollback(int status) {
            return status == 1 || status == 9 || status == 4;
        }
    }
}

