/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManager;
import org.kie.api.runtime.Environment;

public abstract class AbstractPersistenceContextManager {
    protected final Environment env;
    protected final EntityManagerFactory emf;
    protected final TransactionManager txm;
    protected volatile EntityManager appScopedEntityManager;
    protected volatile EntityManager cmdScopedEntityManager;
    protected volatile boolean internalAppScopedEntityManagerFlag;
    protected volatile boolean internalCmdScopedEntityManagerFlag;

    public AbstractPersistenceContextManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.txm = (TransactionManager)env.get("org.kie.transaction.TransactionManager");
    }

    public EntityManager getApplicationScopedEntityManager() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                this.internalAppScopedEntityManagerFlag = true;
                this.appScopedEntityManager = this.emf.createEntityManager();
                this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
                if (this.txm.getStatus() == 4) {
                    this.txm.putResource((Object)"org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
                }
            } else {
                this.internalAppScopedEntityManagerFlag = false;
            }
        }
        return this.appScopedEntityManager;
    }

    public EntityManager getCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
        if (cmdScopedEntityManager == null) {
            cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (cmdScopedEntityManager != null) {
                this.txm.putResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)cmdScopedEntityManager);
            }
            if (cmdScopedEntityManager == null) {
                this.internalCmdScopedEntityManagerFlag = true;
                cmdScopedEntityManager = this.emf.createEntityManager();
                this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)cmdScopedEntityManager);
                this.txm.putResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)cmdScopedEntityManager);
            } else {
                this.internalCmdScopedEntityManagerFlag = false;
            }
        }
        cmdScopedEntityManager.joinTransaction();
        if (this.appScopedEntityManager != null) {
            this.appScopedEntityManager.joinTransaction();
        }
        return cmdScopedEntityManager;
    }

    public void endCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
        if (this.internalCmdScopedEntityManagerFlag) {
            if (cmdScopedEntityManager != null && cmdScopedEntityManager.isOpen()) {
                cmdScopedEntityManager.clear();
            }
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", null);
        }
    }

    public void dispose() {
        if (this.internalAppScopedEntityManagerFlag) {
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
            }
            this.internalAppScopedEntityManagerFlag = false;
            this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", null);
            this.appScopedEntityManager = null;
        }
        if (this.internalCmdScopedEntityManagerFlag) {
            EntityManager cmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
            if (cmdScopedEntityManager != null && cmdScopedEntityManager.isOpen()) {
                cmdScopedEntityManager.close();
            }
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", null);
            this.txm.putResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager", null);
            this.internalCmdScopedEntityManagerFlag = false;
        }
    }

    protected EntityManager getInternalCommandScopedEntityManager() {
        return (EntityManager)this.txm.getResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager");
    }
}

