/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.h2mvstore;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.Storage;
import org.h2.mvstore.MVMap;

public class H2MVStoreStorage<K, V>
implements Storage<K, V> {
    private MVMap<K, V> mvMap;

    public static <K1, V1> Storage<K1, V1> fromMVMap(MVMap<K1, V1> mvMap) {
        return new H2MVStoreStorage<K1, V1>(mvMap);
    }

    private H2MVStoreStorage(MVMap<K, V> mvMap) {
        this.mvMap = mvMap;
    }

    public V get(K key) {
        return (V)this.mvMap.get(key);
    }

    public V getOrDefault(K key, V value) {
        return (V)this.mvMap.getOrDefault(key, value);
    }

    public V put(K key, V value) {
        Object previousValue = this.mvMap.put(key, value);
        this.mvMap.store.commit();
        return (V)previousValue;
    }

    public void putAll(Map<? extends K, ? extends V> otherMap) {
        this.mvMap.putAll(otherMap);
        this.mvMap.store.commit();
    }

    public boolean containsKey(K key) {
        return this.mvMap.containsKey(key);
    }

    public V remove(K key) {
        Object previousValue = this.mvMap.remove(key);
        this.mvMap.store.commit();
        return (V)previousValue;
    }

    public void clear() {
        this.mvMap.clear();
        this.mvMap.store.commit();
    }

    public Collection<V> values() {
        return this.mvMap.values();
    }

    public Set<K> keySet() {
        return this.mvMap.keySet();
    }

    public int size() {
        return this.mvMap.size();
    }

    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }
}

