/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.WorkingMemory;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Iterator;
import org.drools.core.util.bitmask.BitMask;

public class ReteConditionalBranchNode
extends ConditionalBranchNode {
    public ReteConditionalBranchNode() {
    }

    public ReteConditionalBranchNode(int id, LeftTupleSource tupleSource, ConditionalBranchEvaluator branchEvaluator, BuildContext context) {
        super(id, tupleSource, branchEvaluator, context);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple((InternalFactHandle)factHandle, (ModifyPreviousTuples)modifyPreviousTuples, (PropagationContext)context, (InternalWorkingMemory)workingMemory, (LeftTupleSink)this, (ObjectTypeNode.Id)this.getLeftInputOtnId(), (BitMask)this.getLeftInferredMask());
    }

    public void attach(BuildContext context) {
        super.attach(context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.getLeftTupleSource().updateSink((LeftTupleSink)this, propagationContext, workingMemory);
        }
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchNode.ConditionalBranchMemory memory = (ConditionalBranchNode.ConditionalBranchMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        boolean breaking = false;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate((Tuple)leftTuple, (WorkingMemory)workingMemory, memory.context);
        if (conditionalExecution != null) {
            Object object;
            boolean useLeftMemory = true;
            if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                useLeftMemory = false;
            }
            conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
            breaking = conditionalExecution.isBreaking();
        }
        if (!breaking) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchNode.ConditionalBranchMemory memory = (ConditionalBranchNode.ConditionalBranchMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        boolean wasPropagated = leftTuple.getFirstChild() != null;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate((Tuple)leftTuple, (WorkingMemory)workingMemory, memory.context);
        if (wasPropagated) {
            LeftTupleSink mainSink = this.sink.getSinks()[0];
            LeftTupleSink oldSink = leftTuple.getFirstChild().getSink();
            if (conditionalExecution != null) {
                LeftTupleSink newSink = conditionalExecution.getSink().getSinks()[0];
                if (oldSink.equals(newSink)) {
                    conditionalExecution.getSink().propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking()) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                } else {
                    if (oldSink.equals(mainSink)) {
                        if (conditionalExecution.isBreaking()) {
                            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                        } else {
                            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                        }
                    } else {
                        conditionalExecution.getSink().propagateRetractLeftTuple(leftTuple, context, workingMemory);
                    }
                    conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking() && !oldSink.equals(mainSink)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                }
            } else if (oldSink.equals(mainSink)) {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else {
            boolean breaking = false;
            if (conditionalExecution != null) {
                conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        Iterator it = LeftTupleIterator.iterator((InternalWorkingMemory)workingMemory, (LeftTupleSink)this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((MemoryFactory)this);
            }
        } else {
            throw new RuntimeException("ConditionalBranchNode cannot be shared");
        }
        this.getLeftTupleSource().removeTupleSink((LeftTupleSink)this);
    }
}

