/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.io.IOException;
import org.drools.core.WorkingMemory;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.bitmask.BitMask;
import org.drools.reteoo.common.RetePropagationContext;
import org.drools.reteoo.nodes.ReteBetaNodeUtils;

public class ReteAccumulateNode
extends AccumulateNode {
    public ReteAccumulateNode() {
    }

    public ReteAccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, leftInput, rightInput, resultConstraints, sourceBinder, resultBinder, accumulate, unwrapRightObject, context);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple((InternalFactHandle)factHandle, (ModifyPreviousTuples)modifyPreviousTuples, (PropagationContext)context, (InternalWorkingMemory)workingMemory, (LeftTupleSink)this, (ObjectTypeNode.Id)this.getLeftInputOtnId(), (BitMask)this.getLeftInferredMask());
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        ReteBetaNodeUtils.assertObject((BetaNode)this, factHandle, pctx, wm);
    }

    public void attach(BuildContext context) {
        ReteBetaNodeUtils.attach((BetaNode)this, context);
    }

    public void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        ReteBetaNodeUtils.doRemove((BetaNode)this, context, builder, workingMemories);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteBetaNodeUtils.modifyObject((BetaNode)this, factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        AccumulateNode.AccumulateContext accresult = new AccumulateNode.AccumulateContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            leftTuple.setObject((Object)accresult);
        }
        accresult.context = this.accumulate.createContext();
        this.accumulate.init(memory.workingMemoryContext, accresult.context, (Tuple)leftTuple, (WorkingMemory)workingMemory);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        RightTupleMemory rightMemory = memory.betaMemory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        while (rightTuple != null) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) {
                this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accresult, useLeftMemory);
            }
            rightTuple = (RightTuple)rightIt.next((Entry)rightTuple);
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        if (accresult.getAction() == null) {
            this.evaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accresult, useLeftMemory);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getBetaMemory().getLeftTupleMemory().remove(leftTuple);
        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
        if (accctx.getAction() != null) {
            context.removeInsertAction(accctx.getAction());
        }
        leftTuple.setObject(null);
        this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
        if (accctx.propagated) {
            this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
        }
    }

    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (memory.betaMemory.getLeftTupleMemory() == null || memory.betaMemory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.betaMemory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, leftIt);
        while (leftTuple != null) {
            if (this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), leftTuple)) {
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                if (accctx.getAction() == null) {
                    EvaluateResultConstraints action = new EvaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                    accctx.setAction((WorkingMemoryAction)action);
                    context.addInsertAction((WorkingMemoryAction)action);
                }
            }
            leftTuple = (LeftTuple)leftIt.next((Entry)leftTuple);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        BetaMemory bm = memory.getBetaMemory();
        InternalFactHandle origin = (InternalFactHandle)pctx.getFactHandleOrigin();
        if (pctx.getType() == 5) {
            ((RetePropagationContext)pctx).setFactHandle((InternalFactHandle)null);
        }
        bm.getRightTupleMemory().remove(rightTuple);
        this.removePreviousMatchesForRightTuple(rightTuple, pctx, workingMemory, memory, rightTuple.firstChild);
        if (pctx.getType() == 5) {
            ((RetePropagationContext)pctx).setFactHandle(origin);
        }
        rightTuple.unlinkFromRightParent();
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
        BetaMemory bm = memory.betaMemory;
        bm.getLeftTupleMemory().removeAdd(leftTuple);
        this.constraints.updateFromTuple(bm.getContext(), workingMemory, leftTuple);
        LeftTuple childLeftTuple = this.getFirstMatch(leftTuple, accctx, false);
        RightTupleMemory rightMemory = bm.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        if (childLeftTuple != null && rightMemory.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                    }
                    rightTuple = (RightTuple)rightIt.next((Entry)rightTuple);
                }
            } else {
                boolean isDirty = false;
                while (rightTuple != null) {
                    LeftTuple temp;
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            this.addMatch(leftTuple, rightTuple, childLeftTuple, null, workingMemory, memory, accctx, true);
                        } else {
                            temp = childLeftTuple.getLeftParentNext();
                            childLeftTuple.reAddRight();
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        temp = childLeftTuple.getLeftParentNext();
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, false);
                        childLeftTuple = temp;
                        isDirty = !this.accumulate.supportsReverse();
                    }
                    rightTuple = (RightTuple)rightIt.next((Entry)rightTuple);
                }
                if (isDirty) {
                    this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
                }
            }
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        if (accctx.getAction() == null) {
            this.evaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true);
        }
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        BetaMemory bm = memory.betaMemory;
        bm.getRightTupleMemory().removeAdd(rightTuple);
        if (bm.getLeftTupleMemory() == null || bm.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = bm.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, leftIt);
        this.constraints.updateFromFactHandle(bm.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.removePreviousMatchesForRightTuple(rightTuple, context, workingMemory, memory, childLeftTuple);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                        if (accctx.getAction() == null) {
                            EvaluateResultConstraints action = new EvaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction((WorkingMemoryAction)action);
                            context.addInsertAction((WorkingMemoryAction)action);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next((Entry)leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    EvaluateResultConstraints action;
                    if (this.constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        LeftTuple temp = null;
                        if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            temp = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                            childLeftTuple = temp;
                        }
                        this.addMatch(leftTuple, rightTuple, null, childLeftTuple, workingMemory, memory, accctx, true);
                        if (temp != null) {
                            childLeftTuple = temp;
                        }
                        if (accctx.getAction() == null) {
                            action = new EvaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction((WorkingMemoryAction)action);
                            context.addInsertAction((WorkingMemoryAction)action);
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        LeftTuple temp = childLeftTuple.getRightParentNext();
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                        if (accctx.getAction() == null) {
                            action = new EvaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction((WorkingMemoryAction)action);
                            context.addInsertAction((WorkingMemoryAction)action);
                        }
                        childLeftTuple = temp;
                    }
                    leftTuple = (LeftTuple)leftIt.next((Entry)leftTuple);
                }
            }
        }
        this.constraints.resetFactHandle(bm.getContext());
    }

    public void evaluateResultConstraints(AccumulateNode.ActivitySource source, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean useLeftMemory) {
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accctx.context, (Tuple)leftTuple, (WorkingMemory)workingMemory);
        if (result == null) {
            return;
        }
        if (accctx.result == null) {
            InternalFactHandle handle = this.createResultFactHandle(context, workingMemory, leftTuple, result);
            accctx.setResultFactHandle(handle);
            accctx.result = this.createRightTuple(handle, (RightTupleSink)this, context);
        } else {
            accctx.result.getFactHandle().setObject(result);
        }
        boolean isAllowed = result != null;
        int length = this.resultConstraints.length;
        for (int i = 0; isAllowed && i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(accctx.result.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (!this.resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.result.getFactHandle())) {
                isAllowed = false;
            }
            this.resultBinder.resetTuple(memory.resultsContext);
        }
        if (accctx.propagated) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            if (isAllowed) {
                if (AccumulateNode.ActivitySource.LEFT.equals((Object)source)) {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.getFirstChild(), leftTuple, context, workingMemory, useLeftMemory);
                } else {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.getFirstChild(), accctx.result, context, workingMemory, useLeftMemory);
                }
            } else {
                PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
                PropagationContext cancelContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 1, (RuleImpl)context.getRule(), context.getLeftTupleOrigin(), (InternalFactHandle)context.getFactHandle());
                this.sink.propagateRetractLeftTuple(leftTuple, cancelContext, workingMemory);
                accctx.propagated = false;
            }
            this.restoreList(leftTuple, matchings);
        } else if (isAllowed) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            this.sink.propagateAssertLeftTuple(leftTuple, accctx.result, null, null, context, workingMemory, useLeftMemory);
            accctx.propagated = true;
            this.restoreList(leftTuple, matchings);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
            if (accctx.propagated) {
                LeftTuple[] matchings = this.splitList(leftTuple, accctx, true);
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, accctx.result, null, null, sink, true), context, workingMemory);
                this.restoreList(leftTuple, matchings);
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    private void addMatch(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accresult, boolean useLeftMemory) {
        LeftTuple tuple = leftTuple;
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
        }
        this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, (Tuple)tuple, handle, (WorkingMemory)workingMemory);
        if (useLeftMemory) {
            this.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, (LeftTupleSink)this, true);
        }
    }

    private void removeMatch(RightTuple rightTuple, LeftTuple match, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean reaccumulate) {
        LeftTuple leftTuple = match.getLeftParent();
        if (match != null) {
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
        }
        InternalFactHandle handle = rightTuple.getFactHandle();
        LeftTuple tuple = leftTuple;
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
        }
        if (this.accumulate.supportsReverse()) {
            this.accumulate.reverse(memory.workingMemoryContext, accctx.context, (Tuple)tuple, handle, (WorkingMemory)workingMemory);
        } else if (reaccumulate) {
            this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
        }
    }

    private void reaccumulateForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx) {
        this.accumulate.init(memory.workingMemoryContext, accctx.context, (Tuple)leftTuple, (WorkingMemory)workingMemory);
        for (LeftTuple childMatch = this.getFirstMatch(leftTuple, accctx, false); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
            InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
            LeftTuple tuple = leftTuple;
            if (this.unwrapRightObject) {
                tuple = (LeftTuple)childHandle.getObject();
                childHandle = tuple.getLastHandle();
            }
            this.accumulate.accumulate(memory.workingMemoryContext, accctx.context, (Tuple)tuple, childHandle, (WorkingMemory)workingMemory);
        }
    }

    private void removePreviousMatchesForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx) {
        LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
        for (LeftTuple match = matchings[0]; match != null; match = match.getLeftParentNext()) {
            match.unlinkFromRightParent();
        }
        this.accumulate.init(memory.workingMemoryContext, accctx.context, (Tuple)leftTuple, (WorkingMemory)workingMemory);
    }

    private void removePreviousMatchesForRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, LeftTuple firstChild) {
        LeftTuple match = firstChild;
        while (match != null) {
            LeftTuple tmp = match.getRightParentNext();
            LeftTuple parent = match.getLeftParent();
            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)parent.getObject();
            this.removeMatch(rightTuple, match, workingMemory, memory, accctx, true);
            if (accctx.getAction() == null) {
                EvaluateResultConstraints action = new EvaluateResultConstraints(AccumulateNode.ActivitySource.LEFT, parent, context, workingMemory, memory, accctx, true, this);
                accctx.setAction((WorkingMemoryAction)action);
                context.addInsertAction((WorkingMemoryAction)action);
            }
            match = tmp;
        }
    }

    protected LeftTuple[] splitList(LeftTuple parent, AccumulateNode.AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple[] matchings = new LeftTuple[2];
        matchings[0] = this.getFirstMatch(parent, accctx, isUpdatingSink);
        LeftTuple leftTuple = matchings[1] = matchings[0] != null ? parent.getLastChild() : null;
        if (matchings[0] != null) {
            if (parent.getFirstChild() == matchings[0]) {
                parent.setFirstChild(null);
            }
            parent.setLastChild(matchings[0].getLeftParentPrevious());
            if (parent.getLastChild() != null) {
                parent.getLastChild().setLeftParentNext(null);
                matchings[0].setLeftParentPrevious(null);
            }
        }
        return matchings;
    }

    private void restoreList(LeftTuple parent, LeftTuple[] matchings) {
        if (parent.getFirstChild() == null) {
            parent.setFirstChild(matchings[0]);
            parent.setLastChild(matchings[1]);
        } else if (matchings[0] != null) {
            parent.getLastChild().setLeftParentNext(matchings[0]);
            matchings[0].setLeftParentPrevious(parent.getLastChild());
            parent.setLastChild(matchings[1]);
        }
    }

    public LeftTuple getFirstMatch(LeftTuple leftTuple, AccumulateNode.AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple child = leftTuple.getFirstChild();
        if (accctx.propagated) {
            int target = isUpdatingSink ? this.sink.size() - 1 : this.sink.size();
            for (int i = 0; i < target; ++i) {
                child = child.getLeftParentNext();
            }
        }
        return child;
    }

    public static class EvaluateResultConstraints
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private AccumulateNode.ActivitySource source;
        private LeftTuple leftTuple;
        private PropagationContext context;
        private InternalWorkingMemory workingMemory;
        private AccumulateNode.AccumulateMemory memory;
        private AccumulateNode.AccumulateContext accctx;
        private boolean useLeftMemory;
        private ReteAccumulateNode node;

        public EvaluateResultConstraints(PropagationContext context) {
            this.context = context;
        }

        public EvaluateResultConstraints(AccumulateNode.ActivitySource source, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean useLeftMemory, ReteAccumulateNode node) {
            this.source = source;
            this.leftTuple = leftTuple;
            this.context = context;
            this.workingMemory = workingMemory;
            this.memory = memory;
            this.accctx = accctx;
            this.useLeftMemory = useLeftMemory;
            this.node = node;
        }

        public EvaluateResultConstraints(MarshallerReaderContext context) throws IOException {
            throw new UnsupportedOperationException("Should not be present in network on serialisation");
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            throw new UnsupportedOperationException("Should not be present in network on serialisation");
        }

        public void execute(InternalWorkingMemory workingMemory) {
            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)this.leftTuple.getObject();
            accctx.setAction(null);
            this.node.evaluateResultConstraints(this.source, this.leftTuple, this.context, workingMemory, this.memory, accctx, this.useLeftMemory);
        }

        public AccumulateNode.ActivitySource getSource() {
            return this.source;
        }

        public void setSource(AccumulateNode.ActivitySource source) {
            this.source = source;
        }

        public String toString() {
            return "[ResumeInsertAction leftTuple=" + this.leftTuple + "]\n";
        }
    }
}

