/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.LIANodePropagation;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.drools.reteoo.common.RetePropagationList;
import org.drools.reteoo.common.ReteWorkingMemoryEntryPoint;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;

public class ReteWorkingMemory
extends StatefulKnowledgeSessionImpl {
    private List<LIANodePropagation> liaPropagations;
    private Queue<WorkingMemoryAction> actionQueue;
    private AtomicBoolean evaluatingActionQueue = new AtomicBoolean(false);
    private volatile AtomicBoolean firing = new AtomicBoolean(false);
    private final Object syncLock = new Object();

    public ReteWorkingMemory() {
    }

    public ReteWorkingMemory(long id, InternalKnowledgeBase kBase) {
        super(id, kBase);
    }

    public ReteWorkingMemory(long id, InternalKnowledgeBase kBase, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        super(id, kBase, initInitFactHandle, config, environment);
    }

    public ReteWorkingMemory(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        super(id, kBase, handleFactory, propagationContext, config, agenda, environment);
    }

    public ReteWorkingMemory(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, Environment environment, RuleRuntimeEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport, RuleEventListenerSupport ruleEventListenerSupport, InternalAgenda agenda) {
        super(id, kBase, handleFactory, false, propagationContext, config, environment, workingMemoryEventSupport, agendaEventSupport, ruleEventListenerSupport, agenda);
    }

    protected void init() {
        this.actionQueue = new ConcurrentLinkedQueue<WorkingMemoryAction>();
        this.propagationList = new RetePropagationList((InternalWorkingMemory)this);
    }

    public void reset() {
        super.reset();
        this.actionQueue.clear();
    }

    public void reset(int handleId, long handleCounter, long propagationCounter) {
        super.reset(handleId, handleCounter, propagationCounter);
        if (this.liaPropagations != null) {
            this.liaPropagations.clear();
        }
        this.actionQueue.clear();
    }

    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)this.entryPoints.get(name);
        return ep != null ? new ReteWorkingMemoryEntryPoint(this, ep) : null;
    }

    public void addLIANodePropagation(LIANodePropagation liaNodePropagation) {
        if (this.liaPropagations == null) {
            this.liaPropagations = new ArrayList<LIANodePropagation>();
        }
        this.liaPropagations.add(liaNodePropagation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInitialFact() {
        if (this.initialFactHandle == null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.initialFactHandle == null) {
                    this.initInitialFact(this.kBase, null);
                }
            }
        }
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.initInitialFact();
        super.fireUntilHalt(agendaFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.checkAlive();
        if (this.firing.compareAndSet(false, true)) {
            this.initInitialFact();
            try {
                this.startOperation();
                int n = this.internalFireAllRules(agendaFilter, fireLimit);
                return n;
            }
            finally {
                this.endOperation();
                this.firing.set(false);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalFireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        int fireCount = 0;
        try {
            this.kBase.readLock();
            if (this.liaPropagations != null && this.isSequential()) {
                for (LIANodePropagation liaPropagation : this.liaPropagations) {
                    liaPropagation.doPropagation((InternalWorkingMemory)this);
                }
            }
            this.executeQueuedActionsForRete();
            fireCount = this.agenda.fireAllRules(agendaFilter, fireLimit);
        }
        finally {
            this.kBase.readUnlock();
            if (this.kBase.flushModifications()) {
                fireCount += this.internalFireAllRules(agendaFilter, fireLimit);
            }
        }
        return fireCount;
    }

    public void closeLiveQuery(InternalFactHandle factHandle) {
        try {
            this.startOperation();
            this.kBase.readLock();
            this.lock.lock();
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), 0, null, null, factHandle, this.getEntryPoint());
            this.getEntryPointNode().retractQuery(factHandle, pCtx, (InternalWorkingMemory)this);
            pCtx.evaluateActionQueue((InternalWorkingMemory)this);
            this.getFactHandleFactory().destroyFactHandle(factHandle);
        }
        finally {
            this.lock.unlock();
            this.kBase.readUnlock();
            this.endOperation();
        }
    }

    protected BaseNode[] evalQuery(String queryName, DroolsQuery queryObject, InternalFactHandle handle, PropagationContext pCtx) {
        this.initInitialFact();
        BaseNode[] tnodes = this.kBase.getReteooBuilder().getTerminalNodesForQuery(queryName);
        this.getEntryPointNode().assertQuery(handle, pCtx, (InternalWorkingMemory)this);
        pCtx.evaluateActionQueue((InternalWorkingMemory)this);
        return tnodes;
    }

    public Collection<WorkingMemoryAction> getActionQueue() {
        return this.actionQueue;
    }

    public void queueWorkingMemoryAction(WorkingMemoryAction action) {
        try {
            this.startOperation();
            this.actionQueue.add(action);
            this.notifyWaitOnRest();
        }
        finally {
            this.endOperation();
        }
    }

    public void addPropagation(PropagationEntry propagationEntry) {
        if (propagationEntry instanceof WorkingMemoryAction) {
            this.actionQueue.add((WorkingMemoryAction)propagationEntry);
        } else {
            super.addPropagation(propagationEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQueuedActionsForRete() {
        try {
            this.startOperation();
            if (!this.evaluatingActionQueue.compareAndSet(false, true)) return;
            try {
                WorkingMemoryAction action;
                if (this.actionQueue == null || this.actionQueue.isEmpty()) return;
                while ((action = this.actionQueue.poll()) != null) {
                    try {
                        action.execute((InternalWorkingMemory)this);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unexpected exception executing action " + action.toString(), e);
                        return;
                    }
                }
            }
            finally {
                this.evaluatingActionQueue.compareAndSet(true, false);
            }
        }
        finally {
            this.endOperation();
        }
    }

    public Iterator<? extends PropagationEntry> getActionsIterator() {
        return this.actionQueue.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactHandle insert(Object object, Object tmsValue, boolean dynamic, boolean logical, RuleImpl rule, Activation activation) {
        try {
            this.kBase.readLock();
            FactHandle factHandle = super.insert(object, tmsValue, dynamic, logical, rule, activation);
            return factHandle;
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, Activation activation, ObjectTypeConf typeConf) {
        try {
            this.kBase.readLock();
            super.insert(handle, object, rule, activation, typeConf);
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FactHandle factHandle, RuleImpl rule, Activation activation, FactHandle.State fhState) {
        try {
            this.kBase.readLock();
            super.delete(factHandle, rule, activation, fhState);
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        try {
            this.kBase.readLock();
            super.update(factHandle, object, mask, modifiedClass, activation);
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    public void startBatchExecution(ExecutionResultImpl results) {
        this.kBase.readLock();
        super.startBatchExecution(results);
    }

    public void endBatchExecution() {
        super.endBatchExecution();
        this.kBase.readUnlock();
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean tryDeactivate() {
        return true;
    }
}

