/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.rule.EntryPointId;
import org.drools.reflective.util.ClassUtils;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.datasources.BindableArray;
import org.drools.ruleunit.datasources.BindableDataProvider;
import org.drools.ruleunit.datasources.BindableIterable;
import org.drools.ruleunit.datasources.BindableObject;
import org.drools.ruleunit.executor.RuleUnitSessionImpl;
import org.drools.ruleunit.impl.ReflectiveRuleUnitVariable;
import org.kie.api.definition.KiePackage;
import org.kie.internal.ruleunit.RuleUnitDescription;
import org.kie.internal.ruleunit.RuleUnitVariable;

public class RuleUnitDescriptionImpl
implements RuleUnitDescription {
    private final Class<? extends RuleUnit> ruleUnitClass;
    private final Map<String, ReflectiveRuleUnitVariable> varDeclarations = new HashMap<String, ReflectiveRuleUnitVariable>();

    public RuleUnitDescriptionImpl(KiePackage pkg, Class<?> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.indexUnitVars();
    }

    public Class<? extends RuleUnit> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getSimpleName() {
        return this.ruleUnitClass.getSimpleName();
    }

    public String getPackageName() {
        return this.ruleUnitClass.getPackage().getName();
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return this.varDeclarations.containsKey(name) ? Optional.of(new EntryPointId(this.getEntryPointName(name))) : Optional.empty();
    }

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).filter(RuleUnitVariable::isDataSource).map(RuleUnitVariable::getDataSourceParameterType);
    }

    public Optional<Class<?>> getVarType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).map(RuleUnitVariable::getType);
    }

    public boolean hasVar(String name) {
        return this.varDeclarations.containsKey(name);
    }

    public RuleUnitVariable getVar(String name) {
        return this.varDeclarations.get(name);
    }

    public Collection<String> getUnitVars() {
        return this.varDeclarations.keySet();
    }

    public Collection<? extends RuleUnitVariable> getUnitVarDeclarations() {
        return this.varDeclarations.values();
    }

    public boolean hasDataSource(String name) {
        RuleUnitVariable ruleUnitVariable = this.varDeclarations.get(name);
        return ruleUnitVariable != null && ruleUnitVariable.isDataSource();
    }

    public void bindDataSources(RuleUnitSessionImpl wm, RuleUnit ruleUnit) {
        this.varDeclarations.values().forEach(v -> this.bindDataSource(wm, ruleUnit, (ReflectiveRuleUnitVariable)v));
    }

    private void bindDataSource(RuleUnitSessionImpl wm, RuleUnit ruleUnit, ReflectiveRuleUnitVariable v) {
        BindableDataProvider dataSource;
        WorkingMemoryEntryPoint entryPoint = wm.getEntryPoint(this.getEntryPointName(v.getName()));
        if (entryPoint != null && (dataSource = this.findDataSource(ruleUnit, v)) != null) {
            entryPoint.setRuleUnit((Object)ruleUnit);
            dataSource.bind(ruleUnit, entryPoint);
        }
    }

    public void unbindDataSources(RuleUnitSessionImpl wm, RuleUnit ruleUnit) {
        this.varDeclarations.values().forEach(v -> this.unbindDataSource(ruleUnit, (ReflectiveRuleUnitVariable)v));
    }

    private void unbindDataSource(RuleUnit ruleUnit, ReflectiveRuleUnitVariable v) {
        BindableDataProvider dataSource = this.findDataSource(ruleUnit, v);
        if (dataSource != null) {
            dataSource.unbind(ruleUnit);
        }
    }

    public Object getValue(RuleUnit ruleUnit, String identifier) {
        ReflectiveRuleUnitVariable v = this.varDeclarations.get(identifier);
        return v == null ? null : v.getValue(ruleUnit);
    }

    private BindableDataProvider findDataSource(RuleUnit ruleUnit, String name) {
        return this.findDataSource(ruleUnit, this.varDeclarations.get(name));
    }

    private BindableDataProvider findDataSource(RuleUnit ruleUnit, ReflectiveRuleUnitVariable m) {
        try {
            Object value = m.getValue(ruleUnit);
            if (value == null) {
                return null;
            }
            if (value instanceof BindableDataProvider) {
                return (BindableDataProvider)value;
            }
            if (value instanceof Iterable) {
                return new BindableIterable((Iterable)value);
            }
            if (value.getClass().isArray()) {
                return new BindableArray((Object[])value);
            }
            return new BindableObject(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void indexUnitVars() {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || "getUnitIdentity".equals(m.getName()) || "getClass".equals(m.getName()) || (id = ClassUtils.getter2property((String)m.getName())) == null) continue;
            ReflectiveRuleUnitVariable v = new ReflectiveRuleUnitVariable(id, m);
            this.varDeclarations.put(v.getName(), v);
        }
    }
}

