/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.api;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;

public class RuleUnitInstanceFactory {
    public static <T extends RuleUnitData> RuleUnitInstance<T> instance(T ruleUnit) {
        RuleUnit unit = (RuleUnit)RuleUnitServices.ruleUnitMap.get(ruleUnit.getClass().getCanonicalName());
        if (unit == null) {
            throw new RuntimeException("There isn't any generated rule unit for " + ruleUnit.getClass().getCanonicalName() + ", do you forget to run code generation?");
        }
        return unit.createInstance(ruleUnit);
    }

    private static class RuleUnitServices {
        private static final Map<String, RuleUnit> ruleUnitMap = RuleUnitServices.loadRuleUnits();

        private RuleUnitServices() {
        }

        static Map<String, RuleUnit> loadRuleUnits() {
            HashMap<String, RuleUnit> map = new HashMap<String, RuleUnit>();
            ServiceLoader<RuleUnit> loader = ServiceLoader.load(RuleUnit.class);
            for (RuleUnit impl : loader) {
                map.put(impl.id(), impl);
            }
            return map;
        }
    }
}

