/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.api;

import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.DataStream;
import org.drools.ruleunits.api.SingletonStore;
import org.kie.api.internal.utils.KieService;

public interface DataSource<T> {
    public void subscribe(DataProcessor<T> var1);

    public static <T> DataStream<T> createStream() {
        return FactoryHolder.get().createStream();
    }

    public static <T> DataStream<T> createBufferedStream(int bufferSize) {
        return FactoryHolder.get().createBufferedStream(bufferSize);
    }

    public static <T> DataStore<T> createStore() {
        return FactoryHolder.get().createStore();
    }

    public static <T> SingletonStore<T> createSingleton() {
        return FactoryHolder.get().createSingleton();
    }

    public static class FactoryHolder {
        public static Factory get() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static Factory INSTANCE = (Factory)KieService.load(Factory.class);

            private LazyHolder() {
            }
        }
    }

    public static interface Factory
    extends KieService {
        public <T> DataStream<T> createStream();

        public <T> DataStream<T> createBufferedStream(int var1);

        public <T> DataStore<T> createStore();

        public <T> SingletonStore<T> createSingleton();
    }
}

