/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.io.InputStream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleUnitExecutorImpl;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.impl.InterpretedRuleUnitInstance;
import org.drools.ruleunits.impl.factory.AbstractRuleUnit;
import org.drools.ruleunits.impl.factory.AbstractRuleUnits;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class InterpretedRuleUnit<T extends RuleUnitData>
extends AbstractRuleUnit<T> {
    public static <T extends RuleUnitData> RuleUnit<T> of(Class<T> type) {
        return new InterpretedRuleUnit<T>(type.getCanonicalName());
    }

    private InterpretedRuleUnit(String id) {
        super(id, DummyRuleUnits.INSTANCE);
    }

    @Override
    public RuleUnitInstance<T> internalCreateInstance(T data) {
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        Class<?> wmClass = data.getClass();
        String canonicalName = wmClass.getCanonicalName();
        InputStream resourceAsStream = wmClass.getResourceAsStream(String.format("/%s.drl", canonicalName.replace('.', '/')));
        kBuilder.add((Resource)new InputStreamResource(resourceAsStream), ResourceType.DRL);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addPackages(kBuilder.getKnowledgePackages());
        RuleUnitExecutorImpl reteEvaluator = new RuleUnitExecutorImpl((RuleBase)kBase);
        return new InterpretedRuleUnitInstance<T>(this, data, (ReteEvaluator)reteEvaluator);
    }

    public static class DummyRuleUnits
    extends AbstractRuleUnits {
        static final DummyRuleUnits INSTANCE = new DummyRuleUnits();

        @Override
        protected RuleUnit<?> create(String fqcn) {
            throw new UnsupportedOperationException();
        }
    }
}

