/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;

public enum BaseExpressionOperator {
    LIST_OF_CONDITION(0, new String[]{";"}){

        @Override
        protected Optional<String> match(String value) {
            return this.symbols.stream().filter(value::contains).findFirst();
        }

        @Override
        protected boolean eval(Object raw, Object resultValue, Class<?> resultClass, ClassLoader classLoader) {
            String[] stringArray;
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return false;
            }
            String rawValue = (String)raw;
            String[] expressionParts = rawValue.split((String)this.symbols.get(0));
            if (expressionParts.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = expressionParts;
            }
            List results = Arrays.stream(stringArray).map(elem -> 1.findOperator(elem.trim()).eval(elem.trim(), resultValue, resultClass, classLoader)).collect(Collectors.toList());
            return results.size() != 0 && results.stream().allMatch(a -> a);
        }

        public String toString() {
            return "AND ( ; )";
        }
    }
    ,
    LIST_OF_VALUES(1, new String[]{"["}){

        @Override
        public boolean eval(Object rawValue, Object resultValue, Class<?> resultClass, ClassLoader classLoader) {
            List results = this.getValues(rawValue).stream().map(e -> 2.findOperator(e).eval(e, resultValue, resultClass, classLoader)).collect(Collectors.toList());
            return results.stream().anyMatch(a -> a);
        }

        private List<String> getValues(Object raw) {
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return Collections.emptyList();
            }
            String rawValue = ((String)raw).trim();
            if (!rawValue.endsWith("]")) {
                throw new IllegalArgumentException("Malformed expression: " + rawValue);
            }
            return Stream.of(rawValue.substring(1, ((String)raw).length() - 1).split(",")).map(String::trim).collect(Collectors.toList());
        }

        public String toString() {
            return "OR ( [ ] )";
        }
    }
    ,
    EQUALS(2, new String[]{"="}){

        @Override
        protected Object evaluateLiteralExpression(String className, String value, ClassLoader classLoader) {
            String returnValue = this.removeOperator(value);
            returnValue = "null".equals(returnValue) ? null : returnValue;
            return ScenarioBeanUtil.convertValue(className, returnValue, classLoader);
        }

        @Override
        public boolean eval(Object rawValue, Object resultValue, Class<?> resultClass, ClassLoader classLoader) {
            Object parsedResults = rawValue;
            if (parsedResults instanceof String) {
                parsedResults = this.evaluateLiteralExpression(resultClass != null ? resultClass.getCanonicalName() : null, (String)rawValue, classLoader);
            }
            if (parsedResults == null) {
                return resultValue == null;
            }
            if (BaseExpressionOperator.areComparable(resultValue, parsedResults)) {
                return ((Comparable)resultValue).compareTo(parsedResults) == 0;
            }
            return Objects.equals(resultValue, parsedResults);
        }

        public String toString() {
            return "Equal ( = )";
        }
    }
    ,
    NOT_EQUALS(3, new String[]{"!", "!=", "<>"}){

        @Override
        public boolean eval(Object rawValue, Object resultValue, Class<?> resultClass, ClassLoader classLoader) {
            Object valueToTest = rawValue;
            BaseExpressionOperator operator = EQUALS;
            if (valueToTest instanceof String) {
                String rawStringValue = (String)valueToTest;
                valueToTest = this.removeOperator(rawStringValue);
                operator = 4.findOperator((String)valueToTest);
            }
            return !operator.eval(valueToTest, resultValue, resultClass, classLoader);
        }

        public String toString() {
            return "Not Equal ( !, !=, <> )";
        }
    }
    ,
    RANGE(4, new String[]{"<", ">", "<=", ">="}){

        @Override
        public boolean eval(Object raw, Object resultValue, Class<?> resultClass, ClassLoader classLoader) {
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return false;
            }
            String rawValue = (String)raw;
            String operator = this.match(rawValue).get();
            String cleanValue = this.removeOperator(rawValue);
            Object stepValue = ScenarioBeanUtil.convertValue(resultClass.getCanonicalName(), cleanValue, classLoader);
            if (!BaseExpressionOperator.areComparable(stepValue, resultValue)) {
                return false;
            }
            Comparable a = (Comparable)resultValue;
            Comparable b = (Comparable)stepValue;
            switch (operator) {
                case "<": {
                    return a.compareTo(b) < 0;
                }
                case ">": {
                    return a.compareTo(b) > 0;
                }
                case "<=": {
                    return a.compareTo(b) <= 0;
                }
                case ">=": {
                    return a.compareTo(b) >= 0;
                }
            }
            throw new IllegalStateException("This should not happen " + operator);
        }

        public String toString() {
            return "Range ( <, >, <=, >= )";
        }
    };

    final List<String> symbols;
    final int precedence;

    private BaseExpressionOperator(int precedence, String ... symbols) {
        this.precedence = precedence;
        this.symbols = Arrays.asList(symbols);
        this.symbols.sort((a, b) -> Integer.compare(a.length(), b.length()) * -1);
    }

    public static BaseExpressionOperator findOperator(String rawValue) {
        String value = rawValue.trim();
        List sortedOperators = Arrays.stream(BaseExpressionOperator.values()).sorted(Comparator.comparingInt(BaseExpressionOperator::getPrecedence)).collect(Collectors.toList());
        for (BaseExpressionOperator factMappingValueOperator : sortedOperators) {
            if (!factMappingValueOperator.match(value).isPresent()) continue;
            return factMappingValueOperator;
        }
        return EQUALS;
    }

    protected abstract boolean eval(Object var1, Object var2, Class<?> var3, ClassLoader var4);

    protected Object evaluateLiteralExpression(String className, String value, ClassLoader classLoader) {
        throw new IllegalStateException(this.toString() + " operator cannot be used in a GIVEN clause");
    }

    protected Optional<String> match(String value) {
        if (value == null) {
            return Optional.empty();
        }
        value = value.trim();
        return this.symbols.stream().filter(value::startsWith).findFirst();
    }

    protected String removeOperator(String fullString) {
        Optional<String> operatorSymbol = this.match(fullString);
        String value = fullString;
        if (operatorSymbol.isPresent()) {
            String symbolToRemove = operatorSymbol.get();
            int index = value.indexOf(symbolToRemove);
            value = value.substring(index + symbolToRemove.length()).trim();
        }
        return value == null ? null : value.trim();
    }

    private static boolean areComparable(Object a, Object b) {
        return a instanceof Comparable && b instanceof Comparable;
    }

    private int getPrecedence() {
        return this.precedence;
    }
}

