/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.scenariosimulation.backend.runner.model;

import org.drools.scenariosimulation.api.model.Simulation;

public class SimulationWithFileName {

    private final Simulation simulation;
    private final String fileName;

    public SimulationWithFileName(Simulation simulation, String fileName) {
        this.simulation = simulation;
        this.fileName = fileName;
    }

    public Simulation getSimulation() {
        return simulation;
    }

    public String getFileName() {
        return fileName;
    }
}
