/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.kie.api.runtime.KieContainer;

public class RuleScenarioRunnerHelper
extends AbstractRunnerHelper {
    @Override
    protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, SimulationDescriptor simulationDescriptor) {
        if (!ScenarioSimulationModel.Type.RULE.equals((Object)simulationDescriptor.getType())) {
            throw new ScenarioException("Impossible to run a not-RULE simulation with RULE runner");
        }
        RuleScenarioExecutableBuilder ruleScenarioExecutableBuilder = RuleScenarioExecutableBuilder.createBuilder(kieContainer, simulationDescriptor.getDmoSession(), simulationDescriptor.isStateless());
        if (simulationDescriptor.getRuleFlowGroup() != null) {
            ruleScenarioExecutableBuilder.setActiveRuleFlowGroup(simulationDescriptor.getRuleFlowGroup());
        }
        scenarioRunnerData.getGivens().stream().map(ScenarioGiven::getValue).forEach(ruleScenarioExecutableBuilder::insert);
        scenarioRunnerData.getExpects().stream().filter(ScenarioExpect::isNewFact).flatMap(output -> output.getExpectedResult().stream().map(factMappingValue -> new ScenarioResult(output.getFactIdentifier(), (FactMappingValue)factMappingValue))).forEach(scenarioResult -> {
            Class clazz = ScenarioBeanUtil.loadClass(scenarioResult.getFactIdentifier().getClassName(), kieContainer.getClassLoader());
            scenarioRunnerData.addResult((ScenarioResult)scenarioResult);
            ruleScenarioExecutableBuilder.addInternalCondition(clazz, this.createExtractorFunction(expressionEvaluator, scenarioResult.getFactMappingValue(), simulationDescriptor), (ScenarioResult)scenarioResult);
        });
        return ruleScenarioExecutableBuilder.run();
    }

    @Override
    protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
        CoverageAgendaListener coverageAgendaListener = (CoverageAgendaListener)((Object)requestContext.get("COVERAGE_LISTENER"));
        Map<String, Integer> ruleExecuted = coverageAgendaListener.getRuleExecuted();
        Set availableRules = (Set)requestContext.get("RULES_AVAILABLE");
        ScenarioResultMetadata scenarioResultMetadata = new ScenarioResultMetadata(scenarioWithIndex);
        scenarioResultMetadata.addAllAvailable(availableRules);
        scenarioResultMetadata.addAllExecuted(ruleExecuted);
        AtomicInteger counter = new AtomicInteger(0);
        coverageAgendaListener.getAuditsMessages().forEach(auditMessage -> scenarioResultMetadata.addAuditMessage(counter.addAndGet(1), (String)auditMessage, "INFO"));
        return scenarioResultMetadata;
    }

    @Override
    protected void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, Map<String, Object> requestContext) {
        for (ScenarioGiven input : scenarioRunnerData.getGivens()) {
            FactIdentifier factIdentifier = input.getFactIdentifier();
            List<ScenarioExpect> assertionOnFact = scenarioRunnerData.getExpects().stream().filter(elem -> !elem.isNewFact()).filter(elem -> Objects.equals(elem.getFactIdentifier(), factIdentifier)).collect(Collectors.toList());
            if (assertionOnFact.isEmpty()) continue;
            this.getScenarioResultsFromGivenFacts(simulationDescriptor, assertionOnFact, input, expressionEvaluator).forEach(scenarioRunnerData::addResult);
        }
    }

    protected List<ScenarioResult> getScenarioResultsFromGivenFacts(SimulationDescriptor simulationDescriptor, List<ScenarioExpect> scenarioOutputsPerFact, ScenarioGiven input, ExpressionEvaluator expressionEvaluator) {
        FactIdentifier factIdentifier = input.getFactIdentifier();
        Object factInstance = input.getValue();
        ArrayList<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
        for (ScenarioExpect scenarioExpect : scenarioOutputsPerFact) {
            if (scenarioExpect.isNewFact()) continue;
            for (FactMappingValue expectedResult : scenarioExpect.getExpectedResult()) {
                ScenarioResult scenarioResult = this.fillResult(expectedResult, factIdentifier, () -> this.createExtractorFunction(expressionEvaluator, expectedResult, simulationDescriptor).apply(factInstance), expressionEvaluator);
                scenarioResults.add(scenarioResult);
            }
        }
        return scenarioResults;
    }

    protected Function<Object, ResultWrapper> createExtractorFunction(ExpressionEvaluator expressionEvaluator, FactMappingValue expectedResult, SimulationDescriptor simulationDescriptor) {
        return objectToCheck -> {
            ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(expectedResult.getFactIdentifier(), expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List<String> pathToValue = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            ScenarioBeanWrapper<?> scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject(objectToCheck, pathToValue, false);
            Object resultValue = scenarioBeanWrapper.getBean();
            Object expectedResultValue = expectedResult.getRawValue();
            return this.getResultWrapper(factMapping.getClassName(), expectedResult, expressionEvaluator, expectedResultValue, resultValue, scenarioBeanWrapper.getBeanClass());
        };
    }

    @Override
    public Object createObject(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        return ScenarioBeanUtil.fillBean(className, params, classLoader);
    }
}

