/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.Optional;
import java.util.function.Supplier;

public class ResultWrapper<T> {
    private final boolean satisfied;
    private final T result;
    private final T expected;
    private final String errorMessage;

    private ResultWrapper(T result, T expected, boolean satisfied, String errorMessage) {
        this.satisfied = satisfied;
        this.result = result;
        this.expected = expected;
        this.errorMessage = errorMessage;
    }

    public static <T> ResultWrapper<T> createResult(T result) {
        return new ResultWrapper<Object>(result, null, true, null);
    }

    public static <T> ResultWrapper<T> createErrorResult(T result, T expected) {
        return new ResultWrapper<T>(result, expected, false, null);
    }

    public static <T> ResultWrapper<T> createErrorResultWithErrorMessage(String errorMessage) {
        return new ResultWrapper<Object>(null, null, false, errorMessage);
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public T getResult() {
        return this.result;
    }

    public T getExpected() {
        return this.expected;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public T orElse(T defaultValue) {
        return this.satisfied ? this.result : defaultValue;
    }

    public T orElseGet(Supplier<T> defaultSupplier) {
        return this.satisfied ? this.result : defaultSupplier.get();
    }
}

