/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;

public abstract class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    protected boolean commonEvaluateUnaryExpression(Object rawExpression, Object resultValue, Class<?> resultClass) {
        if (this.isStructuredResult(resultClass)) {
            return this.verifyResult(rawExpression, resultValue);
        }
        return this.internalUnaryEvaluation((String)rawExpression, resultValue, resultClass, false);
    }

    protected Object commonEvaluationLiteralExpression(String className, List<String> genericClasses, String raw) {
        if (this.isStructuredInput(className)) {
            return this.convertResult(raw, className, genericClasses);
        }
        return this.internalLiteralEvaluation(raw, className);
    }

    protected boolean isStructuredResult(Class<?> resultClass) {
        return resultClass != null && ScenarioSimulationSharedUtils.isCollection((String)resultClass.getCanonicalName());
    }

    protected boolean isStructuredInput(String className) {
        return ScenarioSimulationSharedUtils.isCollection((String)className);
    }

    protected Object convertResult(String rawString, String className, List<String> genericClasses) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(rawString);
            if (jsonNode.isArray()) {
                return this.createAndFillList((ArrayNode)jsonNode, new ArrayList<Object>(), className, genericClasses);
            }
            if (jsonNode.isObject()) {
                return this.createAndFillObject((ObjectNode)jsonNode, this.createObject(className, genericClasses), className, genericClasses);
            }
            throw new IllegalArgumentException("Malformed raw data");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed raw data", e);
        }
    }

    protected List<Object> createAndFillList(ArrayNode json, List<Object> toReturn, String className, List<String> genericClasses) {
        for (JsonNode node : json) {
            if (this.isSimpleTypeNode(node)) {
                String generic = genericClasses.get(genericClasses.size() - 1);
                Object value = this.internalLiteralEvaluation(this.getSimpleTypeNodeTextValue(node), generic);
                toReturn.add(value);
                continue;
            }
            String genericClassName = ScenarioSimulationSharedUtils.isMap((String)className) ? className : genericClasses.get(genericClasses.size() - 1);
            Object listElement = this.createObject(genericClassName, genericClasses);
            Object returnedObject = this.createAndFillObject((ObjectNode)node, listElement, genericClassName, genericClasses);
            toReturn.add(returnedObject);
        }
        return toReturn;
    }

    protected Object createAndFillObject(ObjectNode json, Object toReturn, String className, List<String> genericClasses) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry<String, List<String>> fieldDescriptor;
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            if (this.isSimpleTypeNode(jsonNode)) {
                fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                Object value = this.internalLiteralEvaluation(this.getSimpleTypeNodeTextValue(jsonNode), fieldDescriptor.getKey());
                this.setField(toReturn, key, value);
                return toReturn;
            }
            if (jsonNode.isArray()) {
                ArrayList<Object> nestedList = new ArrayList<Object>();
                Map.Entry<String, List<String>> fieldDescriptor2 = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                List<Object> returnedList = this.createAndFillList((ArrayNode)jsonNode, nestedList, fieldDescriptor2.getKey(), fieldDescriptor2.getValue());
                this.setField(toReturn, key, returnedList);
                continue;
            }
            if (jsonNode.isObject()) {
                fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                Object nestedObject = this.createObject(fieldDescriptor.getKey(), fieldDescriptor.getValue());
                Object returnedObject = this.createAndFillObject((ObjectNode)jsonNode, nestedObject, fieldDescriptor.getKey(), fieldDescriptor.getValue());
                this.setField(toReturn, key, returnedObject);
                continue;
            }
            if (this.isEmptyText(jsonNode)) continue;
            fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
            this.setField(toReturn, key, this.internalLiteralEvaluation(jsonNode.textValue(), fieldDescriptor.getKey()));
        }
        return toReturn;
    }

    protected boolean verifyResult(Object rawExpression, Object resultRaw) {
        if (resultRaw != null && !(resultRaw instanceof List) && !(resultRaw instanceof Map)) {
            throw new IllegalArgumentException("A list or map was expected");
        }
        if (!(rawExpression instanceof String)) {
            throw new IllegalArgumentException("Malformed raw data");
        }
        String raw = (String)rawExpression;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(raw);
            if (jsonNode.isArray()) {
                return this.verifyList((ArrayNode)jsonNode, (List)resultRaw);
            }
            if (jsonNode.isObject()) {
                return this.verifyObject((ObjectNode)jsonNode, resultRaw);
            }
            throw new IllegalArgumentException("Malformed raw data");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed raw data", e);
        }
    }

    protected boolean verifyList(ArrayNode json, List resultRaw) {
        if (resultRaw == null) {
            return this.isListEmpty(json);
        }
        for (JsonNode node : json) {
            boolean success = false;
            for (Object result : resultRaw) {
                boolean simpleTypeNode = this.isSimpleTypeNode(node);
                if (simpleTypeNode && this.internalUnaryEvaluation(this.getSimpleTypeNodeTextValue(node), result, result.getClass(), true)) {
                    success = true;
                    continue;
                }
                if (simpleTypeNode || !this.verifyObject((ObjectNode)node, result)) continue;
                success = true;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    protected boolean verifyObject(ObjectNode json, Object resultRaw) {
        if (resultRaw == null) {
            return this.isObjectEmpty(json);
        }
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Class<?> fieldClass;
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            Object fieldValue = this.extractFieldValue(resultRaw, key);
            Class<?> clazz = fieldClass = fieldValue != null ? fieldValue.getClass() : null;
            if (!(this.isSimpleTypeNode(jsonNode) ? !this.internalUnaryEvaluation(this.getSimpleTypeNodeTextValue(jsonNode), fieldValue, fieldClass, true) : (jsonNode.isArray() ? !this.verifyList((ArrayNode)jsonNode, (List)fieldValue) : (jsonNode.isObject() ? !this.verifyObject((ObjectNode)jsonNode, fieldValue) : !this.internalUnaryEvaluation(jsonNode.textValue(), fieldValue, fieldClass, true))))) continue;
            return false;
        }
        return true;
    }

    protected boolean isNodeEmpty(JsonNode json) {
        if (json.isArray()) {
            return this.isListEmpty((ArrayNode)json);
        }
        if (json.isObject()) {
            return this.isObjectEmpty((ObjectNode)json);
        }
        return this.isEmptyText(json);
    }

    protected boolean isListEmpty(ArrayNode json) {
        for (JsonNode node : json) {
            if (this.isNodeEmpty(node)) continue;
            return false;
        }
        return true;
    }

    protected boolean isObjectEmpty(ObjectNode json) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            JsonNode element = (JsonNode)((Map.Entry)fields.next()).getValue();
            if (this.isNodeEmpty(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEmptyText(JsonNode jsonNode) {
        return jsonNode.textValue() == null || jsonNode.textValue().isEmpty();
    }

    protected boolean isSimpleTypeNode(JsonNode jsonNode) {
        if (!jsonNode.isObject()) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        int numberOfFields = objectNode.size();
        return numberOfFields == 1 && objectNode.has("value");
    }

    protected String getSimpleTypeNodeTextValue(JsonNode jsonNode) {
        if (!this.isSimpleTypeNode(jsonNode)) {
            throw new IllegalArgumentException("Parameter does not contains a simple type");
        }
        return jsonNode.get("value").textValue();
    }

    protected abstract boolean internalUnaryEvaluation(String var1, Object var2, Class<?> var3, boolean var4);

    protected abstract Object internalLiteralEvaluation(String var1, String var2);

    protected abstract Object extractFieldValue(Object var1, String var2);

    protected abstract Object createObject(String var1, List<String> var2);

    protected abstract void setField(Object var1, String var2, Object var3);

    protected abstract Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object var1, String var2, String var3, List<String> var4);
}

