/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collection;
import java.util.List;
import org.drools.scenariosimulation.backend.fluent.ConditionFilter;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.command.RegistryContext;

public class ValidateFactCommand
implements ExecutableCommand<Void> {
    private final List<FactCheckerHandle> factToCheck;

    public ValidateFactCommand(List<FactCheckerHandle> factToCheck) {
        this.factToCheck = factToCheck;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection objects = ksession.getObjects((ObjectFilter)new ConditionFilter(this.factToCheck));
        if (!objects.isEmpty()) {
            this.factToCheck.forEach(fact -> fact.getScenarioResult().setResult(true));
        } else {
            this.factToCheck.forEach(fact -> fact.getScenarioResult().getFactMappingValue().setExceptionMessage("There is no instance which satisfies the expected conditions"));
        }
        return null;
    }
}

