/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.Optional;
import java.util.function.Supplier;

public class ValueWrapper<T> {
    private final boolean valid;
    private final T value;
    private final T expected;
    private final String errorMessage;

    private ValueWrapper(T value, T expected, boolean valid, String errorMessage) {
        this.valid = valid;
        this.value = value;
        this.expected = expected;
        this.errorMessage = errorMessage;
    }

    public static <T> ValueWrapper<T> of(T value) {
        return new ValueWrapper<Object>(value, null, true, null);
    }

    public static <T> ValueWrapper<T> errorWithValidValue(T value, T expected) {
        return new ValueWrapper<T>(value, expected, false, null);
    }

    public static <T> ValueWrapper<T> errorWithMessage(String message) {
        return new ValueWrapper<Object>(null, null, false, message);
    }

    public static <T> ValueWrapper<T> errorEmptyMessage() {
        return new ValueWrapper<Object>(null, null, false, null);
    }

    public boolean isValid() {
        return this.valid;
    }

    public T getValue() {
        return this.value;
    }

    public T getExpected() {
        return this.expected;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public T orElse(T defaultValue) {
        return this.valid ? this.value : defaultValue;
    }

    public T orElseGet(Supplier<T> defaultSupplier) {
        return this.valid ? this.value : defaultSupplier.get();
    }
}

