/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.util.JsonUtils;

public abstract class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    @Override
    public Object evaluateLiteralExpression(String rawExpression, String className, List<String> genericClasses) {
        if (this.isStructuredInput(className)) {
            return this.convertResult(rawExpression, className, genericClasses);
        }
        return this.internalLiteralEvaluation(rawExpression, className);
    }

    @Override
    public ExpressionEvaluatorResult evaluateUnaryExpression(String rawExpression, Object resultValue, Class<?> resultClass) {
        if (this.isStructuredResult(resultClass)) {
            return this.verifyResult(rawExpression, resultValue, resultClass);
        }
        return ExpressionEvaluatorResult.of(this.internalUnaryEvaluation(rawExpression, resultValue, resultClass, false));
    }

    protected boolean isStructuredResult(Class<?> resultClass) {
        return resultClass != null && ScenarioSimulationSharedUtils.isCollection((String)resultClass.getCanonicalName());
    }

    protected boolean isStructuredInput(String className) {
        return ScenarioSimulationSharedUtils.isCollection((String)className);
    }

    protected Object convertResult(String rawString, String className, List<String> genericClasses) {
        if (rawString == null) {
            return null;
        }
        Optional<JsonNode> optionalJsonNode = JsonUtils.convertFromStringToJSONNode(rawString);
        JsonNode jsonNode = optionalJsonNode.orElseThrow(() -> new IllegalArgumentException("Malformed raw data"));
        if (jsonNode.isTextual()) {
            return this.internalLiteralEvaluation(jsonNode.asText(), className);
        }
        if (jsonNode.isArray()) {
            return this.createAndFillList((ArrayNode)jsonNode, new ArrayList<Object>(), className, genericClasses);
        }
        if (jsonNode.isObject()) {
            return this.createAndFillObject((ObjectNode)jsonNode, this.createObject(className, genericClasses), className, genericClasses);
        }
        throw new IllegalArgumentException("Malformed raw data");
    }

    protected List<Object> createAndFillList(ArrayNode json, List<Object> toReturn, String className, List<String> genericClasses) {
        for (JsonNode node : json) {
            if (this.isSimpleTypeNode(node)) {
                String generic = genericClasses.get(genericClasses.size() - 1);
                Object value = this.internalLiteralEvaluation(this.getSimpleTypeNodeTextValue(node), generic);
                toReturn.add(value);
                continue;
            }
            String genericClassName = ScenarioSimulationSharedUtils.isMap((String)className) ? className : genericClasses.get(genericClasses.size() - 1);
            Object listElement = this.createObject(genericClassName, genericClasses);
            Object returnedObject = this.createAndFillObject((ObjectNode)node, listElement, genericClassName, genericClasses);
            toReturn.add(returnedObject);
        }
        return toReturn;
    }

    protected Object createAndFillObject(ObjectNode json, Object toReturn, String className, List<String> genericClasses) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry<String, List<String>> fieldDescriptor;
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            if (this.isSimpleTypeNode(jsonNode)) {
                fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                Object value = this.internalLiteralEvaluation(this.getSimpleTypeNodeTextValue(jsonNode), fieldDescriptor.getKey());
                this.setField(toReturn, key, value);
                return toReturn;
            }
            if (jsonNode.isArray()) {
                ArrayList<Object> nestedList = new ArrayList<Object>();
                Map.Entry<String, List<String>> fieldDescriptor2 = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                List<Object> returnedList = this.createAndFillList((ArrayNode)jsonNode, nestedList, fieldDescriptor2.getKey(), fieldDescriptor2.getValue());
                this.setField(toReturn, key, returnedList);
                continue;
            }
            if (jsonNode.isObject()) {
                fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                Object nestedObject = this.createObject(fieldDescriptor.getKey(), fieldDescriptor.getValue());
                Object returnedObject = this.createAndFillObject((ObjectNode)jsonNode, nestedObject, fieldDescriptor.getKey(), fieldDescriptor.getValue());
                this.setField(toReturn, key, returnedObject);
                continue;
            }
            if (this.isEmptyText(jsonNode)) continue;
            fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
            this.setField(toReturn, key, this.internalLiteralEvaluation(jsonNode.textValue(), fieldDescriptor.getKey()));
        }
        return toReturn;
    }

    protected ExpressionEvaluatorResult verifyResult(String rawExpression, Object resultRaw, Class<?> resultClass) {
        if (rawExpression == null) {
            return ExpressionEvaluatorResult.of(resultRaw == null);
        }
        if (resultRaw != null && !(resultRaw instanceof List) && !(resultRaw instanceof Map)) {
            throw new IllegalArgumentException("A list or map was expected");
        }
        Optional<JsonNode> optionalJsonNode = JsonUtils.convertFromStringToJSONNode(rawExpression);
        JsonNode jsonNode = optionalJsonNode.orElseThrow(() -> new IllegalArgumentException("Malformed raw data"));
        if (jsonNode.isTextual()) {
            return ExpressionEvaluatorResult.of(this.internalUnaryEvaluation(jsonNode.asText(), resultRaw, resultClass, false));
        }
        if (jsonNode.isArray()) {
            return this.verifyList((ArrayNode)jsonNode, (List)resultRaw);
        }
        if (jsonNode.isObject()) {
            return this.verifyObject((ObjectNode)jsonNode, resultRaw);
        }
        throw new IllegalArgumentException("Malformed raw data");
    }

    protected ExpressionEvaluatorResult verifyList(ArrayNode json, List<Object> resultRaw) {
        if (resultRaw == null) {
            return ExpressionEvaluatorResult.of(this.isListEmpty(json));
        }
        int elementNumber = 0;
        for (JsonNode node : json) {
            ++elementNumber;
            boolean success = false;
            boolean simpleTypeNode = this.isSimpleTypeNode(node);
            for (Object result : resultRaw) {
                if (simpleTypeNode && this.internalUnaryEvaluation(this.getSimpleTypeNodeTextValue(node), result, result.getClass(), true)) {
                    success = true;
                } else if (!simpleTypeNode && this.verifyObject((ObjectNode)node, result).isSuccessful()) {
                    success = true;
                }
                if (!success) continue;
                break;
            }
            if (success) continue;
            ExpressionEvaluatorResult evaluatorResult = ExpressionEvaluatorResult.ofFailed();
            if (simpleTypeNode) {
                evaluatorResult.setWrongValue(this.getSimpleTypeNodeTextValue(node));
            }
            evaluatorResult.addListItemStepToPath(elementNumber);
            return evaluatorResult;
        }
        return ExpressionEvaluatorResult.ofSuccessful();
    }

    protected ExpressionEvaluatorResult verifyObject(ObjectNode json, Object resultRaw) {
        if (resultRaw == null) {
            return ExpressionEvaluatorResult.of(this.isObjectEmpty(json));
        }
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            Object fieldValue = this.extractFieldValue(resultRaw, key);
            Class<?> fieldClass = fieldValue != null ? fieldValue.getClass() : null;
            ExpressionEvaluatorResult evaluatorResult = ExpressionEvaluatorResult.ofFailed();
            if (this.isSimpleTypeNode(jsonNode)) {
                String nodeValue = this.getSimpleTypeNodeTextValue(jsonNode);
                if (this.internalUnaryEvaluation(nodeValue, fieldValue, fieldClass, true)) continue;
                evaluatorResult.setWrongValue(nodeValue);
                evaluatorResult.addMapItemStepToPath(key);
                return evaluatorResult;
            }
            if (jsonNode.isArray()) {
                evaluatorResult = this.verifyList((ArrayNode)jsonNode, (List)fieldValue);
                if (evaluatorResult.isSuccessful()) continue;
                evaluatorResult.addMapItemStepToPath(key);
                return evaluatorResult;
            }
            if (jsonNode.isObject()) {
                evaluatorResult = this.verifyObject((ObjectNode)jsonNode, fieldValue);
                if (evaluatorResult.isSuccessful()) continue;
                if (resultRaw instanceof Map) {
                    evaluatorResult.addMapItemStepToPath(key);
                } else {
                    evaluatorResult.addFieldItemStepToPath(key);
                }
                return evaluatorResult;
            }
            if (this.internalUnaryEvaluation(jsonNode.textValue(), fieldValue, fieldClass, true)) continue;
            return ExpressionEvaluatorResult.ofFailed(jsonNode.textValue(), key);
        }
        return ExpressionEvaluatorResult.ofSuccessful();
    }

    protected boolean isNodeEmpty(JsonNode json) {
        if (json.isArray()) {
            return this.isListEmpty((ArrayNode)json);
        }
        if (json.isObject()) {
            return this.isObjectEmpty((ObjectNode)json);
        }
        return this.isEmptyText(json);
    }

    protected boolean isListEmpty(ArrayNode json) {
        for (JsonNode node : json) {
            if (this.isNodeEmpty(node)) continue;
            return false;
        }
        return true;
    }

    protected boolean isObjectEmpty(ObjectNode json) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            JsonNode element = (JsonNode)((Map.Entry)fields.next()).getValue();
            if (this.isNodeEmpty(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEmptyText(JsonNode jsonNode) {
        return jsonNode.textValue() == null || jsonNode.textValue().isEmpty();
    }

    protected boolean isSimpleTypeNode(JsonNode jsonNode) {
        if (!jsonNode.isObject()) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        int numberOfFields = objectNode.size();
        return numberOfFields == 1 && objectNode.has("value");
    }

    protected String getSimpleTypeNodeTextValue(JsonNode jsonNode) {
        if (!this.isSimpleTypeNode(jsonNode)) {
            throw new IllegalArgumentException("Parameter does not contains a simple type");
        }
        return jsonNode.get("value").textValue();
    }

    protected abstract boolean internalUnaryEvaluation(String var1, Object var2, Class<?> var3, boolean var4);

    protected abstract Object internalLiteralEvaluation(String var1, String var2);

    protected abstract Object extractFieldValue(Object var1, String var2);

    protected abstract Object createObject(String var1, List<String> var2);

    protected abstract void setField(Object var1, String var2, Object var3);

    protected abstract Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object var1, String var2, String var3, List<String> var4);
}

