/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunnerHelper {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void run(KieContainer kieContainer, ScesimModelDescriptor scesimModelDescriptor, ScenarioWithIndex scenarioWithIndex, ExpressionEvaluatorFactory expressionEvaluatorFactory, ClassLoader classLoader, ScenarioRunnerData scenarioRunnerData, Settings settings, Background background) {
        Scenario scenario = (Scenario)scenarioWithIndex.getScesimData();
        this.extractBackgroundValues(background, classLoader, expressionEvaluatorFactory).forEach(scenarioRunnerData::addBackground);
        this.extractGivenValues(scesimModelDescriptor, scenario.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory).forEach(scenarioRunnerData::addGiven);
        this.extractExpectedValues(scenario.getUnmodifiableFactMappingValues()).forEach(scenarioRunnerData::addExpect);
        Map<String, Object> requestContext = this.executeScenario(kieContainer, scenarioRunnerData, expressionEvaluatorFactory, scesimModelDescriptor, settings);
        scenarioRunnerData.setMetadata(this.extractResultMetadata(requestContext, scenarioWithIndex));
        this.verifyConditions(scesimModelDescriptor, scenarioRunnerData, expressionEvaluatorFactory, requestContext);
        this.validateAssertion(scenarioRunnerData.getResults(), scesimModelDescriptor);
    }

    protected List<InstanceGiven> extractBackgroundValues(Background background, ClassLoader classLoader, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        ArrayList<InstanceGiven> backgrounds = new ArrayList<InstanceGiven>();
        boolean hasError = false;
        for (BackgroundData row : background.getUnmodifiableData()) {
            try {
                List<InstanceGiven> givens = this.extractGivenValues(background.getScesimModelDescriptor(), row.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
                backgrounds.addAll(givens);
            }
            catch (ScenarioException e) {
                hasError = true;
            }
        }
        if (hasError) {
            throw new ScenarioException("Error in BACKGROUND data");
        }
        return backgrounds;
    }

    protected List<InstanceGiven> extractGivenValues(ScesimModelDescriptor scesimModelDescriptor, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        ArrayList<InstanceGiven> instanceGiven = new ArrayList<InstanceGiven>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.GIVEN);
        boolean hasError = false;
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            try {
                FactIdentifier factIdentifier = entry.getKey();
                Map<List<String>, Object> paramsForBean = this.getParamsForBean(scesimModelDescriptor, factIdentifier, entry.getValue(), expressionEvaluatorFactory);
                Object bean = this.createObject(this.getDirectMapping(paramsForBean), factIdentifier.getClassName(), paramsForBean, classLoader);
                instanceGiven.add(new InstanceGiven(factIdentifier, bean));
            }
            catch (Exception e) {
                String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getCanonicalName();
                this.logger.error("Error in GIVEN data " + entry.getKey() + ": " + errorMessage, (Throwable)e);
                hasError = true;
            }
        }
        if (hasError) {
            throw new ScenarioException("Error in GIVEN data");
        }
        return instanceGiven;
    }

    protected ValueWrapper<Object> getDirectMapping(Map<List<String>, Object> params) {
        for (Map.Entry<List<String>, Object> entry : params.entrySet()) {
            if (!entry.getKey().isEmpty()) continue;
            return ValueWrapper.of(entry.getValue());
        }
        return ValueWrapper.errorWithMessage("No direct mapping available");
    }

    protected List<ScenarioExpect> extractExpectedValues(List<FactMappingValue> factMappingValues) {
        ArrayList<ScenarioExpect> scenarioExpect = new ArrayList<ScenarioExpect>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.EXPECT);
        Set inputFacts = factMappingValues.stream().filter(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())).filter(elem -> !this.isFactMappingValueToSkip((FactMappingValue)elem)).map(FactMappingValue::getFactIdentifier).collect(Collectors.toSet());
        Iterator<Map.Entry<FactIdentifier, List<FactMappingValue>>> iterator = groupByFactIdentifier.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FactIdentifier, List<FactMappingValue>> entry;
            FactIdentifier factIdentifier;
            scenarioExpect.add(new ScenarioExpect(factIdentifier, entry.getValue(), !inputFacts.contains(factIdentifier = (entry = iterator.next()).getKey())));
        }
        return scenarioExpect;
    }

    protected Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifierAndFilter(List<FactMappingValue> factMappingValues, FactMappingType type) {
        HashMap<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = new HashMap<FactIdentifier, List<FactMappingValue>>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            FactIdentifier factIdentifier = factMappingValue.getFactIdentifier();
            if (this.isFactMappingValueToSkip(factMappingValue)) continue;
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            if (expressionIdentifier == null) {
                throw new IllegalArgumentException("ExpressionIdentifier malformed");
            }
            if (!Objects.equals(expressionIdentifier.getType(), type)) continue;
            groupByFactIdentifier.computeIfAbsent(factIdentifier, key -> new ArrayList()).add(factMappingValue);
        }
        return groupByFactIdentifier;
    }

    protected boolean isFactMappingValueToSkip(FactMappingValue factMappingValue) {
        return factMappingValue.getRawValue() == null;
    }

    protected Map<List<String>, Object> getParamsForBean(ScesimModelDescriptor scesimModelDescriptor, FactIdentifier factIdentifier, List<FactMappingValue> factMappingValues, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        HashMap<List<String>, Object> paramsForBean = new HashMap<List<String>, Object>();
        boolean hasError = false;
        for (FactMappingValue factMappingValue : factMappingValues) {
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)scesimModelDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List pathToField = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            ExpressionEvaluator expressionEvaluator = expressionEvaluatorFactory.getOrCreate(factMappingValue);
            try {
                Object value = expressionEvaluator.evaluateLiteralExpression((String)factMappingValue.getRawValue(), factMapping.getClassName(), factMapping.getGenericTypes());
                paramsForBean.put(pathToField, value);
            }
            catch (RuntimeException e) {
                factMappingValue.setExceptionMessage(e.getMessage());
                hasError = true;
            }
        }
        if (hasError) {
            throw new ScenarioException("Error in one or more input values");
        }
        return paramsForBean;
    }

    protected void validateAssertion(List<ScenarioResult> scenarioResults, ScesimModelDescriptor scesimModelDescriptor) {
        for (ScenarioResult scenarioResult : scenarioResults) {
            if (scenarioResult.getResult()) continue;
            this.throwScenarioException(scenarioResult.getFactMappingValue(), scesimModelDescriptor);
        }
    }

    private void throwScenarioException(FactMappingValue factMappingValue, ScesimModelDescriptor scesimModelDescriptor) {
        FactMapping factMapping = (FactMapping)scesimModelDescriptor.getFactMapping(factMappingValue.getFactIdentifier(), factMappingValue.getExpressionIdentifier()).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
        String factName = String.join((CharSequence)".", factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList()));
        if (FactMappingValueStatus.FAILED_WITH_ERROR == factMappingValue.getStatus()) {
            throw new ScenarioException(this.determineExceptionMessage(factMappingValue, factName), true);
        }
        if (FactMappingValueStatus.FAILED_WITH_EXCEPTION == factMappingValue.getStatus()) {
            throw new ScenarioException(ScenarioSimulationServerMessages.getGenericScenarioExceptionMessage(factMappingValue.getExceptionMessage()));
        }
        throw new IllegalStateException("Illegal FactMappingValue status");
    }

    private String determineExceptionMessage(FactMappingValue factMappingValue, String factName) {
        if (factMappingValue.getCollectionPathToValue() == null) {
            return ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage(factName, factMappingValue.getRawValue(), factMappingValue.getErrorValue());
        }
        return ScenarioSimulationServerMessages.getCollectionFactExceptionMessage(factName, factMappingValue.getCollectionPathToValue(), factMappingValue.getErrorValue());
    }

    protected ScenarioResult fillResult(FactMappingValue expectedResult, Supplier<ValueWrapper<?>> resultSupplier, ExpressionEvaluator expressionEvaluator) {
        ValueWrapper<?> resultValue = resultSupplier.get();
        if (resultValue.isValid()) {
            expectedResult.resetStatus();
        } else if (resultValue.getErrorMessage().isPresent()) {
            expectedResult.setExceptionMessage(resultValue.getErrorMessage().get());
        } else if (resultValue.getCollectionPathToValue() != null) {
            expectedResult.setCollectionPathToValue(resultValue.getCollectionPathToValue());
            expectedResult.setErrorValue(resultValue.getValue());
        } else {
            try {
                expectedResult.setErrorValue((Object)expressionEvaluator.fromObjectToExpression(resultValue.getValue()));
            }
            catch (Exception e) {
                expectedResult.setExceptionMessage(e.getMessage());
            }
        }
        return new ScenarioResult(expectedResult, resultValue.getValue()).setResult(resultValue.isValid());
    }

    protected ValueWrapper getResultWrapper(String className, FactMappingValue expectedResult, ExpressionEvaluator expressionEvaluator, Object expectedResultRaw, Object resultRaw, Class<?> resultClass) {
        try {
            ExpressionEvaluatorResult evaluationResult = expressionEvaluator.evaluateUnaryExpression((String)expectedResultRaw, resultRaw, resultClass);
            if (evaluationResult.isSuccessful()) {
                return ValueWrapper.of(resultRaw);
            }
            if (ScenarioSimulationSharedUtils.isCollection((String)className)) {
                return ValueWrapper.errorWithCollectionPathToValue(evaluationResult.getWrongValue(), evaluationResult.getPathToWrongValue());
            }
            return ValueWrapper.errorWithValidValue(resultRaw, expectedResultRaw);
        }
        catch (Exception e) {
            expectedResult.setExceptionMessage(e.getMessage());
            return ValueWrapper.errorWithMessage(e.getMessage());
        }
    }

    protected abstract ScenarioResultMetadata extractResultMetadata(Map<String, Object> var1, ScenarioWithIndex var2);

    protected abstract Map<String, Object> executeScenario(KieContainer var1, ScenarioRunnerData var2, ExpressionEvaluatorFactory var3, ScesimModelDescriptor var4, Settings var5);

    protected abstract void verifyConditions(ScesimModelDescriptor var1, ScenarioRunnerData var2, ExpressionEvaluatorFactory var3, Map<String, Object> var4);

    protected abstract Object createObject(ValueWrapper<Object> var1, String var2, Map<List<String>, Object> var3, ClassLoader var4);
}

