/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.util.ResourceHelper;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class ScenarioJunitActivator
extends ParentRunner<ScenarioRunnerDTO> {
    public static final String ACTIVATOR_CLASS_NAME = "ScenarioJunitActivatorTest";
    public static final Function<String, String> ACTIVATOR_CLASS_CODE = modulePackage -> String.format("package %s;\n/**\n* Do not remove this file\n*/\n@%s(%s.class)\npublic class %s {\n}", modulePackage, RunWith.class.getCanonicalName(), ScenarioJunitActivator.class.getCanonicalName(), ACTIVATOR_CLASS_NAME);

    public ScenarioJunitActivator(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<ScenarioRunnerDTO> getChildren() {
        return this.getResources().map(this::parseFile).filter(item -> this.isNotSkipFromBuild(item.getSettings())).collect(Collectors.toList());
    }

    protected Description describeChild(ScenarioRunnerDTO child) {
        return AbstractScenarioRunner.getDescriptionForSimulation(Optional.of(child.getFileName()), child.getScenarioWithIndices());
    }

    protected void runChild(ScenarioRunnerDTO child, RunNotifier notifier) {
        KieContainer kieClasspathContainer = this.getKieContainer();
        AbstractScenarioRunner scenarioRunner = this.newRunner(kieClasspathContainer, child);
        scenarioRunner.run(notifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ScenarioRunnerDTO parseFile(String path) {
        try (Scanner scanner = new Scanner(new File(path));){
            String rawFile = scanner.useDelimiter("\\Z").next();
            ScenarioSimulationModel scenarioSimulationModel = this.getXmlReader().unmarshal(rawFile);
            ScenarioRunnerDTO scenarioRunnerDTO = new ScenarioRunnerDTO(scenarioSimulationModel, path);
            return scenarioRunnerDTO;
        }
        catch (FileNotFoundException e) {
            throw new ScenarioException("File not found, this should not happen: " + path, e);
        }
        catch (Exception e) {
            throw new ScenarioException("Issue on parsing file: " + path, e);
        }
    }

    protected boolean isNotSkipFromBuild(Settings settings) {
        return !settings.isSkipFromBuild();
    }

    ScenarioSimulationXMLPersistence getXmlReader() {
        return ScenarioSimulationXMLPersistence.getInstance();
    }

    Stream<String> getResources() {
        return ResourceHelper.getResourcesByExtension("scesim");
    }

    KieContainer getKieContainer() {
        return KieServices.get().getKieClasspathContainer();
    }

    AbstractScenarioRunner newRunner(KieContainer kieContainer, ScenarioRunnerDTO scenarioRunnerDTO) {
        return AbstractScenarioRunner.getSpecificRunnerProvider(scenarioRunnerDTO.getSettings().getType()).create(kieContainer, scenarioRunnerDTO);
    }
}

