/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.imports.Import;
import org.drools.scenariosimulation.api.utils.ConstantsHolder;
import org.drools.scenariosimulation.backend.interfaces.ThrowingConsumer;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.drools.scenariosimulation.backend.util.InMemoryMigrationStrategy;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.kie.utll.xml.XStreamUtils;
import org.w3c.dom.Document;

public class ScenarioSimulationXMLPersistence {
    private static final ScenarioSimulationXMLPersistence INSTANCE = new ScenarioSimulationXMLPersistence();
    private static final String CURRENT_VERSION = new ScenarioSimulationModel().getVersion();
    private static final Pattern p = Pattern.compile("ScenarioSimulationModel version=\"([0-9]+\\.[0-9]+)");
    private XStream xt;
    private MigrationStrategy migrationStrategy = new InMemoryMigrationStrategy();

    private ScenarioSimulationXMLPersistence() {
        this.xt = XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)new DomDriver());
        this.xt.addPermission((TypePermission)new WildcardTypePermission(new String[]{"org.drools.scenariosimulation.api.model.*"}));
        this.xt.setMode(1001);
        this.xt.autodetectAnnotations(true);
        ScenarioSimulationXMLPersistence.configureXStreamMappings(this.xt);
    }

    public static void configureXStreamMappings(XStream toConfigure) {
        toConfigure.alias("ExpressionElement", ExpressionElement.class);
        toConfigure.alias("ExpressionIdentifier", ExpressionIdentifier.class);
        toConfigure.alias("FactIdentifier", FactIdentifier.class);
        toConfigure.alias("FactMapping", FactMapping.class);
        toConfigure.alias("FactMappingType", FactMappingType.class);
        toConfigure.alias("FactMappingValue", FactMappingValue.class);
        toConfigure.alias("Scenario", Scenario.class);
        toConfigure.alias("BackgroundData", BackgroundData.class);
        toConfigure.alias("ScenarioSimulationModel", ScenarioSimulationModel.class);
        toConfigure.alias("Simulation", Simulation.class);
        toConfigure.alias("Background", Background.class);
        toConfigure.alias("SimulationDescriptor", ScesimModelDescriptor.class);
        toConfigure.alias("Import", Import.class);
        toConfigure.alias("Settings", Settings.class);
    }

    public static ScenarioSimulationXMLPersistence getInstance() {
        return INSTANCE;
    }

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static String cleanUpUnusedNodes(String input) throws Exception {
        String toReturn = DOMParserUtil.cleanupNodes(input, "Scenario", "simulationDescriptor");
        for (String setting : ConstantsHolder.SETTINGS) {
            toReturn = DOMParserUtil.cleanupNodes(toReturn, "simulationDescriptor", setting);
        }
        toReturn = DOMParserUtil.replaceNodeName(DOMParserUtil.getDocument(toReturn), "simulation", "scenarios", "scesimData");
        toReturn = DOMParserUtil.replaceNodeName(DOMParserUtil.getDocument(toReturn), "simulation", "simulationDescriptor", "scesimModelDescriptor");
        toReturn = DOMParserUtil.replaceNodeName(DOMParserUtil.getDocument(toReturn), "background", "simulationDescriptor", "scesimModelDescriptor");
        return toReturn;
    }

    public static double getColumnWidth(String expressionIdentifierName) {
        ExpressionIdentifier.NAME expressionName = ExpressionIdentifier.NAME.Other;
        try {
            expressionName = ExpressionIdentifier.NAME.valueOf((String)expressionIdentifierName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (expressionName) {
            case Index: {
                return 70.0;
            }
            case Description: {
                return 300.0;
            }
        }
        return 114.0;
    }

    public String marshal(ScenarioSimulationModel sc) {
        return this.xt.toXML((Object)sc);
    }

    public ScenarioSimulationModel unmarshal(String rawXml) throws Exception {
        return this.unmarshal(rawXml, true);
    }

    public ScenarioSimulationModel unmarshal(String rawXml, boolean migrate) throws Exception {
        if (rawXml == null || rawXml.trim().equals("")) {
            throw new IllegalArgumentException("Malformed file, content is empty!");
        }
        String xml = migrate ? this.migrateIfNecessary(rawXml) : rawXml;
        return this.internalUnmarshal(xml);
    }

    public String migrateIfNecessary(String rawXml) throws Exception {
        boolean supported;
        String fileVersion = this.extractVersion(rawXml);
        ThrowingConsumer<Document> migrator = this.getMigrationStrategy().start();
        switch (fileVersion) {
            case "1.0": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_0to1_1());
            }
            case "1.1": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_1to1_2());
            }
            case "1.2": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_2to1_3());
            }
            case "1.3": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_3to1_4());
            }
            case "1.4": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_4to1_5());
            }
            case "1.5": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_5to1_6());
            }
            case "1.6": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_6to1_7());
            }
            case "1.7": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_7to1_8());
                supported = true;
                break;
            }
            default: {
                supported = CURRENT_VERSION.equals(fileVersion);
            }
        }
        if (!supported) {
            throw new IllegalArgumentException("Version " + fileVersion + " of the file is not supported. Current version is " + CURRENT_VERSION);
        }
        migrator = migrator.andThen(this.getMigrationStrategy().end());
        Document document = DOMParserUtil.getDocument(rawXml);
        migrator.accept(document);
        return DOMParserUtil.getString(document);
    }

    public String extractVersion(String rawXml) {
        Matcher m = p.matcher(rawXml);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("Impossible to extract version from the file");
    }

    public MigrationStrategy getMigrationStrategy() {
        return this.migrationStrategy;
    }

    public void setMigrationStrategy(MigrationStrategy migrationStrategy) {
        this.migrationStrategy = migrationStrategy;
    }

    protected ScenarioSimulationModel internalUnmarshal(String xml) throws Exception {
        xml = ScenarioSimulationXMLPersistence.cleanUpUnusedNodes(xml);
        Object o = this.xt.fromXML(xml);
        return (ScenarioSimulationModel)o;
    }
}

