/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.drools.scenariosimulation.backend.fluent.RuleStatefulScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.kie.api.KieBase;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.definition.rule.InternalRule;

public interface RuleScenarioExecutableBuilder {
    public static final String COVERAGE_LISTENER = "COVERAGE_LISTENER";
    public static final String RULES_AVAILABLE = "RULES_AVAILABLE";

    public static RuleScenarioExecutableBuilder createBuilder(KieContainer kieContainer, String kieSessionName, boolean stateless) {
        if (stateless) {
            return new RuleStatelessScenarioExecutableBuilder(kieContainer, kieSessionName);
        }
        return new RuleStatefulScenarioExecutableBuilder(kieContainer, kieSessionName);
    }

    public static RuleScenarioExecutableBuilder createBuilder(KieContainer kieContainer) {
        return new RuleStatefulScenarioExecutableBuilder(kieContainer);
    }

    public void addInternalCondition(Class<?> var1, Function<Object, ValueWrapper> var2, ScenarioResult var3);

    public void setActiveAgendaGroup(String var1);

    public void setActiveRuleFlowGroup(String var1);

    public void insert(Object var1);

    public Map<String, Object> run();

    default public Set<String> getAvailableRules(KieBase kieBase, String activeAgendaGroup) {
        HashSet<String> toReturn = new HashSet<String>();
        for (KiePackage kiePackage : kieBase.getKiePackages()) {
            kiePackage.getRules().stream().filter(rule -> KieDefinition.KnowledgeType.RULE.equals((Object)rule.getKnowledgeType())).map(rule -> (InternalRule)rule).forEach(internalRule -> {
                if (internalRule.isMainAgendaGroup() || Objects.equals(activeAgendaGroup, internalRule.getAgendaGroup())) {
                    toReturn.add(RuleScenarioExecutableBuilder.prettyFullyQualifiedName((Rule)internalRule));
                }
            });
        }
        return toReturn;
    }

    public static String prettyFullyQualifiedName(Rule rule) {
        String packageName = rule.getPackageName();
        return rule.getName() + (String)(packageName != null && !packageName.isEmpty() ? " (" + packageName + ")" : "");
    }
}

