/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.drools.base.RuleBase;
import org.drools.base.common.DroolsObjectInputStream;
import org.drools.base.common.DroolsObjectOutputStream;
import org.drools.base.factmodel.traits.TraitFactory;
import org.drools.base.util.Drools;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.impl.WorkingMemoryReteExpireAction;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.marshalling.MarshallerWriteContext;
import org.drools.core.marshalling.TupleKey;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.util.KeyStoreHelper;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.ProtobufMessages;
import org.drools.serialization.protobuf.WorkingMemoryReteAssertAction;
import org.drools.serialization.protobuf.actions.ProtobufBehaviorExpireWMAction;
import org.drools.serialization.protobuf.actions.ProtobufBeliefSystemLogicalCallback;
import org.drools.serialization.protobuf.actions.ProtobufWorkingMemoryReteAssertAction;
import org.drools.serialization.protobuf.actions.ProtobufWorkingMemoryReteExpireAction;
import org.drools.serialization.protobuf.marshalling.ActivationKey;
import org.drools.serialization.protobuf.marshalling.MarshallingHelper;
import org.drools.serialization.protobuf.marshalling.ProcessMarshaller;
import org.drools.tms.beliefsystem.simple.BeliefSystemLogicalCallback;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class PersisterHelper
extends MarshallingHelper {
    public static WorkingMemoryAction readWorkingMemoryAction(MarshallerReaderContext context) throws IOException {
        short type = context.readShort();
        switch (type) {
            case 1: {
                return new WorkingMemoryReteAssertAction(context);
            }
            case 4: {
                return new BeliefSystemLogicalCallback(context);
            }
            case 5: {
                return new WorkingMemoryReteExpireAction(context);
            }
            case 8: {
                return new SlidingTimeWindow.BehaviorExpireWMAction(context);
            }
        }
        return null;
    }

    public static WorkingMemoryAction deserializeWorkingMemoryAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) throws IOException {
        switch (_action.getType()) {
            case ASSERT: {
                return new ProtobufWorkingMemoryReteAssertAction(context, _action);
            }
            case LOGICAL_RETRACT: {
                return new ProtobufBeliefSystemLogicalCallback(context, _action);
            }
            case EXPIRE: {
                return new ProtobufWorkingMemoryReteExpireAction(context, _action);
            }
            case BEHAVIOR_EXPIRE: {
                return new ProtobufBehaviorExpireWMAction(context, _action);
            }
        }
        return null;
    }

    public void write(ProtobufMarshallerWriteContext context) throws IOException {
    }

    public static ActivationKey createActivationKey(String pkgName, String ruleName, ProtobufMessages.Tuple _tuple) {
        return PersisterHelper.createActivationKey(pkgName, ruleName, PersisterHelper.toArrayOfObject(PersisterHelper.createTupleArray(_tuple)));
    }

    public static ProtobufMessages.Tuple createTuple(Tuple leftTuple) {
        ProtobufMessages.Tuple.Builder _tuple = ProtobufMessages.Tuple.newBuilder();
        for (TupleImpl entry = leftTuple.skipEmptyHandles(); entry != null; entry = entry.getParent()) {
            _tuple.addHandleId(entry.getFactHandle().getId());
        }
        return _tuple.build();
    }

    public static long[] createTupleArray(ProtobufMessages.Tuple _tuple) {
        long[] tuple = new long[_tuple.getHandleIdCount()];
        for (int i = 0; i < tuple.length; ++i) {
            tuple[i] = _tuple.getHandleId(tuple.length - i - 1);
        }
        return tuple;
    }

    public static TupleKey createTupleKey(ProtobufMessages.Tuple _tuple) {
        return new TupleKey(PersisterHelper.createTupleArray(_tuple));
    }

    public static ProtobufMessages.Activation createActivation(String packageName, String ruleName, Tuple tuple) {
        return ProtobufMessages.Activation.newBuilder().setPackageName(packageName).setRuleName(ruleName).setTuple(PersisterHelper.createTuple(tuple)).build();
    }

    public static void writeToStreamWithHeader(MarshallerWriteContext context, Message payload) throws IOException {
        TraitFactory traitFactory;
        ProtobufMessages.Header.Builder _header = ProtobufMessages.Header.newBuilder();
        _header.setVersion(ProtobufMessages.Version.newBuilder().setVersionMajor(Drools.getMajorVersion()).setVersionMinor(Drools.getMinorVersion()).setVersionRevision(Drools.getRevisionVersion()).build());
        PersisterHelper.writeStrategiesIndex(context, _header);
        InternalRuleBase kBase = context.getKnowledgeBase();
        if (kBase != null && (traitFactory = RuntimeComponentFactory.get().getTraitFactory((RuleBase)kBase)) != null) {
            PersisterHelper.writeRuntimeDefinedClasses(traitFactory, context, _header);
        }
        byte[] buff = payload.toByteArray();
        PersisterHelper.sign(_header, buff);
        _header.setPayload(ByteString.copyFrom((byte[])buff));
        context.write(_header.build().toByteArray());
    }

    private static void writeRuntimeDefinedClasses(TraitFactory traitFactory, MarshallerWriteContext context, ProtobufMessages.Header.Builder _header) {
        if (context.getKnowledgeBase() == null) {
            return;
        }
        ProjectClassLoader pcl = (ProjectClassLoader)context.getKnowledgeBase().getRootClassLoader();
        if (pcl.getStore() == null || pcl.getStore().isEmpty()) {
            return;
        }
        ArrayList runtimeClassNames = new ArrayList(pcl.getStore().keySet());
        Collections.sort(runtimeClassNames);
        ProtobufMessages.RuntimeClassDef.Builder _classDef = ProtobufMessages.RuntimeClassDef.newBuilder();
        for (String resourceName : runtimeClassNames) {
            if (!traitFactory.isRuntimeClass(resourceName)) continue;
            _classDef.clear();
            _classDef.setClassFqName(resourceName);
            _classDef.setClassDef(ByteString.copyFrom((byte[])((byte[])pcl.getStore().get(resourceName))));
            _header.addRuntimeClassDefinitions(_classDef.build());
        }
    }

    private static void writeStrategiesIndex(MarshallerWriteContext context, ProtobufMessages.Header.Builder _header) throws IOException {
        for (Map.Entry entry : context.getUsedStrategies().entrySet()) {
            ProtobufMessages.Header.StrategyIndex.Builder _strat = ProtobufMessages.Header.StrategyIndex.newBuilder().setId((Integer)entry.getValue()).setName(((ObjectMarshallingStrategy)entry.getKey()).getName());
            ObjectMarshallingStrategy.Context ctx = (ObjectMarshallingStrategy.Context)context.getStrategyContext().get(entry.getKey());
            if (ctx != null) {
                try (ByteString.Output os = ByteString.newOutput();){
                    ctx.write((ObjectOutputStream)new DroolsObjectOutputStream((OutputStream)os));
                    _strat.setData(os.toByteString());
                }
            }
            _header.addStrategy(_strat.build());
        }
    }

    private static void sign(ProtobufMessages.Header.Builder _header, byte[] buff) {
        KeyStoreHelper helper = KeyStoreHelper.get();
        if (helper.isSigned()) {
            try {
                _header.setSignature(ProtobufMessages.Signature.newBuilder().setKeyAlias(helper.getPvtKeyAlias()).setSignature(ByteString.copyFrom((byte[])helper.signDataWithPrivateKey(buff))).build());
            }
            catch (Exception e) {
                throw new RuntimeException("Error signing session: " + e.getMessage(), e);
            }
        }
    }

    private static ProtobufMessages.Header loadStrategiesCheckSignature(MarshallerReaderContext context, ProtobufMessages.Header _header) throws ClassNotFoundException, IOException {
        PersisterHelper.loadStrategiesIndex(context, _header);
        byte[] sessionbuff = _header.getPayload().toByteArray();
        PersisterHelper.checkSignature(_header, sessionbuff);
        return _header;
    }

    public static ProtobufMessages.Header readFromStreamWithHeaderPreloaded(MarshallerReaderContext context, ExtensionRegistry registry) throws IOException, ClassNotFoundException {
        byte[] preloaded = PersisterHelper.preload((InputStream)context);
        ProtobufMessages.Header _header = ProtobufMessages.Header.parseFrom(preloaded, (ExtensionRegistryLite)registry);
        return PersisterHelper.loadStrategiesCheckSignature(context, _header);
    }

    private static byte[] preload(InputStream stream) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream preloaded = new ByteArrayOutputStream();
        while ((read = stream.read(buf)) != -1) {
            preloaded.write(buf, 0, read);
        }
        return preloaded.toByteArray();
    }

    private static void loadStrategiesIndex(MarshallerReaderContext context, ProtobufMessages.Header _header) throws IOException, ClassNotFoundException {
        for (ProtobufMessages.Header.StrategyIndex _entry : _header.getStrategyList()) {
            ObjectMarshallingStrategy strategyObject = context.getResolverStrategyFactory().getStrategyObject(_entry.getName());
            if (strategyObject == null) {
                throw new IllegalStateException("No strategy of type " + _entry.getName() + " available.");
            }
            context.getUsedStrategies().put(_entry.getId(), strategyObject);
            ObjectMarshallingStrategy.Context ctx = strategyObject.createContext();
            context.getStrategyContexts().put(strategyObject, ctx);
            if (!_entry.hasData() || ctx == null) continue;
            ClassLoader classLoader = null;
            if (context.getClassLoader() != null) {
                classLoader = context.getClassLoader();
            } else if (context.getKnowledgeBase() != null) {
                classLoader = context.getKnowledgeBase().getRootClassLoader();
            }
            if (classLoader instanceof ProjectClassLoader) {
                PersisterHelper.readRuntimeDefinedClasses(_header, (ProjectClassLoader)classLoader);
            }
            ctx.read((ObjectInputStream)new DroolsObjectInputStream(_entry.getData().newInput(), classLoader));
        }
    }

    public static void readRuntimeDefinedClasses(ProtobufMessages.Header _header, ProjectClassLoader pcl) throws IOException, ClassNotFoundException {
        if (_header.getRuntimeClassDefinitionsCount() > 0) {
            for (ProtobufMessages.RuntimeClassDef def : _header.getRuntimeClassDefinitionsList()) {
                String resourceName = def.getClassFqName();
                byte[] byteCode = def.getClassDef().toByteArray();
                if (pcl.getStore().containsKey(resourceName)) continue;
                pcl.getStore().put(resourceName, byteCode);
            }
        }
    }

    private static void checkSignature(ProtobufMessages.Header _header, byte[] sessionbuff) {
        KeyStoreHelper helper = KeyStoreHelper.get();
        boolean signed = _header.hasSignature();
        if (helper.isSigned() != signed) {
            throw new RuntimeException("This environment is configured to work with " + (helper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (signed ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        if (signed) {
            if (helper.getPubKeyStore() == null) {
                throw new RuntimeException("The session was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
            try {
                if (!helper.checkDataWithPublicKey(_header.getSignature().getKeyAlias(), sessionbuff, _header.getSignature().getSignature().toByteArray())) {
                    throw new RuntimeException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
                }
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Invalid key checking signature: " + e.getMessage(), e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Error accessing Key Store: " + e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No algorithm available: " + e.getMessage(), e);
            }
            catch (SignatureException e) {
                throw new RuntimeException("Signature Exception: " + e.getMessage(), e);
            }
        }
    }

    public static ExtensionRegistry buildRegistry(MarshallerReaderContext context, ProcessMarshaller processMarshaller) {
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        if (processMarshaller != null) {
            context.setParameterObject((Object)registry);
            processMarshaller.init(context);
        }
        return registry;
    }
}

