/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.serialization.protobuf.TimersOutputMarshaller;
import org.drools.serialization.protobuf.timers.BehaviorJobContextTimerOutputMarshaller;
import org.drools.serialization.protobuf.timers.ExpireJobContextTimerOutputMarshaller;
import org.drools.serialization.protobuf.timers.TimerNodeTimerOutputMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.internal.marshalling.MarshallerFactory;

public class ProtobufMarshallerWriteContext
extends ObjectOutputStream
implements MarshallerWriteContext {
    private final InternalKnowledgeBase kBase;
    private final InternalWorkingMemory wm;
    private final Map<Integer, BaseNode> sinks;
    private long clockTime;
    public final Map<Class<?>, TimersOutputMarshaller> writersByClass;
    public final PrintStream out = System.out;
    private final ObjectMarshallingStrategyStore objectMarshallingStrategyStore;
    private final Map<ObjectMarshallingStrategy, Integer> usedStrategies;
    private final Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> strategyContext;
    public final Map<LeftTuple, Integer> terminalTupleMap;
    private final boolean marshalProcessInstances;
    private final boolean marshalWorkItems;
    private final Environment env;
    private Object parameterObject;

    public ProtobufMarshallerWriteContext(OutputStream stream, InternalKnowledgeBase kBase, InternalWorkingMemory wm, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Environment env) throws IOException {
        this(stream, kBase, wm, sinks, resolverStrategyFactory, true, true, env);
    }

    public ProtobufMarshallerWriteContext(OutputStream stream, InternalKnowledgeBase kBase, InternalWorkingMemory wm, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, boolean marshalProcessInstances, boolean marshalWorkItems, Environment env) throws IOException {
        super(stream);
        this.kBase = kBase;
        this.wm = wm;
        this.sinks = sinks;
        this.writersByClass = new HashMap();
        this.writersByClass.put(SlidingTimeWindow.BehaviorJobContext.class, new BehaviorJobContextTimerOutputMarshaller());
        this.writersByClass.put(ObjectTypeNode.ExpireJobContext.class, new ExpireJobContextTimerOutputMarshaller());
        this.writersByClass.put(PhreakTimerNode.TimerNodeJobContext.class, new TimerNodeTimerOutputMarshaller());
        if (resolverStrategyFactory == null) {
            ObjectMarshallingStrategy[] strats = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            if (strats == null) {
                strats = this.getMarshallingStrategy();
            }
            this.objectMarshallingStrategyStore = new ObjectMarshallingStrategyStoreImpl(strats);
        } else {
            this.objectMarshallingStrategyStore = resolverStrategyFactory;
        }
        this.usedStrategies = new HashMap<ObjectMarshallingStrategy, Integer>();
        this.strategyContext = new HashMap<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context>();
        this.terminalTupleMap = new IdentityHashMap<LeftTuple, Integer>();
        this.marshalProcessInstances = marshalProcessInstances;
        this.marshalWorkItems = marshalWorkItems;
        this.env = env;
    }

    protected ObjectMarshallingStrategy[] getMarshallingStrategy() {
        return new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
    }

    public Integer getStrategyIndex(ObjectMarshallingStrategy strategy) {
        Integer index = this.usedStrategies.get(strategy);
        if (index == null) {
            index = this.usedStrategies.size();
            this.usedStrategies.put(strategy, index);
            this.strategyContext.put(strategy, strategy.createContext());
        }
        return index;
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public ObjectMarshallingStrategyStore getObjectMarshallingStrategyStore() {
        return this.objectMarshallingStrategyStore;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    public void setParameterObject(Object parameterObject) {
        this.parameterObject = parameterObject;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.wm;
    }

    public Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> getStrategyContext() {
        return this.strategyContext;
    }

    public Map<ObjectMarshallingStrategy, Integer> getUsedStrategies() {
        return this.usedStrategies;
    }

    public Map<Integer, BaseNode> getSinks() {
        return this.sinks;
    }

    public boolean isMarshalProcessInstances() {
        return this.marshalProcessInstances;
    }

    public boolean isMarshalWorkItems() {
        return this.marshalWorkItems;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public long getClockTime() {
        return this.clockTime;
    }

    public void setClockTime(long clockTime) {
        this.clockTime = clockTime;
    }

    public Object getWriterForClass(Class<?> c) {
        return this.writersByClass.get(c);
    }

    public void setWriterForClass(Class<?> c, Object writer) {
        this.writersByClass.put(c, (TimersOutputMarshaller)writer);
    }
}

