/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.commands.runtime.FlatQueryResults;
import org.drools.core.QueryResultsImpl;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.runtime.rule.impl.FlatQueryResultRow;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class QueryTest
extends CommonTestMethodBase {
    @Rule
    public TestName testName = new TestName();

    @Before
    public void before() {
        System.out.println("] " + this.testName.getMethodName());
    }

    private static QueryResults getQueryResults(KieSession session, String queryName, Object ... arguments) throws Exception {
        QueryResultsImpl results = (QueryResultsImpl)session.getQueryResults(queryName, arguments);
        FlatQueryResults flatResults = new FlatQueryResults(results);
        ((AbstractIntegerAssert)Assertions.assertThat((int)flatResults.size()).as("Query results size", new Object[0])).isEqualTo(results.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)flatResults.getIdentifiers().length).as("Query results identifiers", new Object[0])).isEqualTo(results.getIdentifiers().length);
        TreeSet<String> resultIds = new TreeSet<String>(Arrays.asList(results.getIdentifiers()));
        TreeSet<String> flatIds = new TreeSet<String>(Arrays.asList(flatResults.getIdentifiers()));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])flatIds.toArray()).as("Flat query results identifiers", new Object[0])).isEqualTo((Object)resultIds.toArray());
        String[] identifiers = results.getIdentifiers();
        Iterator copyFlatIter = flatResults.iterator();
        for (int i = 0; i < results.size(); ++i) {
            QueryResultsRowImpl row = results.get(i);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)copyFlatIter.hasNext()).as("Round-tripped flat query results contain less rows than original query results", new Object[0])).isTrue();
            QueryResultsRow copyRow = (QueryResultsRow)copyFlatIter.next();
            for (String id : identifiers) {
                Object obj = row.get(id);
                if (obj != null) {
                    Object copyObj = copyRow.get(id);
                    ((AbstractBooleanAssert)Assertions.assertThat((obj != null && obj.equals(copyObj) ? 1 : 0) != 0).as("Flat query result [" + i + "] does not contain result: '" + id + "': " + obj + "/" + copyObj, new Object[0])).isTrue();
                }
                FactHandle fh = row.getFactHandle(id);
                FactHandle copyFh = copyRow.getFactHandle(id);
                if (fh == null) continue;
                ((ObjectAssert)Assertions.assertThat((Object)copyFh).as("Flat query result [" + i + "] does not contain facthandle: '" + ((InternalFactHandle)fh).getId() + "'", new Object[0])).isNotNull();
                String fhStr = fh.toExternalForm();
                fhStr = fhStr.substring(0, fhStr.lastIndexOf(":"));
                String copyFhStr = copyFh.toExternalForm();
                copyFhStr = copyFhStr.substring(0, copyFhStr.lastIndexOf(":"));
                ((AbstractStringAssert)Assertions.assertThat((String)copyFhStr).as("Unequal fact handles for fact handle '" + ((InternalFactHandle)fh).getId() + "':", new Object[0])).isEqualTo(fhStr);
            }
        }
        TreeSet<String> copyFlatIds = new TreeSet<String>(Arrays.asList(flatResults.getIdentifiers()));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])copyFlatIds.toArray()).as("Flat query results identifiers", new Object[0])).isEqualTo((Object)flatIds.toArray());
        return flatResults;
    }

    @Test
    public void testQuery() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"simple_query_test.drl"});
        KieSession session = this.createKieSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        FactHandle factHandle = session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        String queryName = "simple query";
        QueryResults results = QueryTest.getQueryResults(session, queryName, new Object[0]);
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        QueryResultsRow row = (QueryResultsRow)results.iterator().next();
        if (row instanceof FlatQueryResultRow) {
            FlatQueryResultRow flatRow = (FlatQueryResultRow)row;
            Assertions.assertThat((int)flatRow.getIdentifiers().size()).isEqualTo(0);
        } else if (row instanceof QueryResultsRowImpl) {
            QueryResultsRowImpl rowImpl = (QueryResultsRowImpl)row;
            Assertions.assertThat((int)rowImpl.getDeclarations().size()).isEqualTo(0);
        }
    }

    @Test
    public void testQueryRemoval() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"simple_query_test.drl"});
        KieSession session = this.createKieSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        org.kie.api.definition.rule.Rule rule = (org.kie.api.definition.rule.Rule)kbase.getKiePackage("org.drools.compiler.test").getRules().iterator().next();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple query");
        kbase.removeQuery("org.drools.compiler.test", "simple query");
        Assertions.assertThat((boolean)kbase.getKiePackage("org.drools.compiler.test").getRules().isEmpty()).isTrue();
        try {
            results = session.getQueryResults("simple query", new Object[0]);
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)e.getMessage().endsWith("does not exist")).isTrue();
        }
    }
}

