/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jboss;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.jboss.JBossPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration urls;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName()));
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Could not read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                url = (URL)urls.nextElement();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("URL from classloader: " + url));
                }
                VirtualFile root = VFS.getRoot((URL)url);
                root.visit((VirtualFileVisitor)new MatchingClassVisitor(this, test, classes, null));
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Could not read entries in url: " + url), (Throwable)ioe);
            }
        }
    }

    static /* synthetic */ void access$100(JBossPackageScanClassResolver x0, PackageScanFilter x1, String x2, Set x3) {
        x0.addIfMatching(x1, x2, x3);
    }
}

