/*
 * Decompiled with CFR 0.152.
 */
package org.drools.server.service;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.drools.CheckedDroolsException;
import org.drools.server.KnowledgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest")
public class KnowledgeServiceRest {
    private static Logger logger = LoggerFactory.getLogger(KnowledgeServiceRest.class);
    private KnowledgeService service;

    @POST
    @Path(value="/execute")
    public Response execute(@FormParam(value="command") String command) {
        String response;
        if (command == null || command.length() == 0) {
            logger.error("Invalid or null command " + command);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            response = this.getService().executeCommand(command);
        }
        catch (CheckedDroolsException e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Response.ResponseBuilder builder = Response.ok((Object)response, (String)"application/xml");
        return builder.build();
    }

    public void setService(KnowledgeService service) {
        this.service = service;
    }

    public KnowledgeService getService() {
        return this.service;
    }
}

