/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.util.List;
import org.drools.container.spring.beans.KnowledgeAgentBeanFactory;
import org.drools.container.spring.beans.StatefulKnowledgeSessionBeanFactory;
import org.drools.container.spring.beans.StatelessKnowledgeSessionBeanFactory;
import org.drools.container.spring.namespace.DefinitionParserHelper;
import org.drools.container.spring.namespace.EventListenersUtil;
import org.drools.container.spring.namespace.KnowledgeLoggerUtil;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KnowledgeSessionDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String KBASE_ATTRIBUTE = "kbase";
    private static final String EMF_ATTRIBUTE = "entity-manager-factory";
    private static final String TX_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String FORCLASS_ATTRIBUTE = "for-class";
    private static final String IMPLEMENTATION_ATTRIBUTE = "implementation";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String GRID_NODE_ATTRIBUTE = "node";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String LISTENERS_ATTRIBUTE = "listeners";
    private static final String KEEP_REFERENCE = "keep-reference";
    private static final String CLOCK_TYPE = "clock-type";
    private static final String WORK_ITEMS = "work-item-handlers";
    private static final String WORK_ITEM = "work-item-handler";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Element batch;
        String name;
        BeanDefinitionBuilder factory;
        String id = element.getAttribute("id");
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), "id", id);
        String kbase = element.getAttribute(KBASE_ATTRIBUTE);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), KBASE_ATTRIBUTE, kbase);
        String sessionType = element.getAttribute(TYPE_ATTRIBUTE);
        if ("stateful".equals(sessionType)) {
            factory = BeanDefinitionBuilder.rootBeanDefinition(StatefulKnowledgeSessionBeanFactory.class);
        } else {
            if (!"stateless".equals(sessionType)) throw new IllegalArgumentException("Invalid value for type attribute: " + sessionType);
            factory = BeanDefinitionBuilder.rootBeanDefinition(StatelessKnowledgeSessionBeanFactory.class);
        }
        factory.addPropertyReference(KBASE_ATTRIBUTE, kbase);
        String node = element.getAttribute(GRID_NODE_ATTRIBUTE);
        if (node != null && node.length() > 0) {
            factory.addPropertyReference(GRID_NODE_ATTRIBUTE, node);
        }
        if (StringUtils.hasText((String)(name = element.getAttribute(NAME_ATTRIBUTE)))) {
            factory.addPropertyValue(NAME_ATTRIBUTE, (Object)name);
        } else {
            factory.addPropertyValue(NAME_ATTRIBUTE, (Object)id);
        }
        String listeners = element.getAttribute(LISTENERS_ATTRIBUTE);
        if (StringUtils.hasText((String)listeners)) {
            factory.addPropertyValue("eventListenersFromGroup", (Object)new RuntimeBeanReference(listeners));
        }
        EventListenersUtil.parseEventListeners(parserContext, factory, element);
        KnowledgeLoggerUtil.parseRuntimeLoggers(parserContext, factory, element);
        Element ksessionConf = DomUtils.getChildElementByTagName((Element)element, (String)"configuration");
        if (ksessionConf != null) {
            List children;
            Element persistenceElm = DomUtils.getChildElementByTagName((Element)ksessionConf, (String)"jpa-persistence");
            if (persistenceElm != null) {
                BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(StatefulKnowledgeSessionBeanFactory.JpaConfiguration.class);
                String loadId = persistenceElm.getAttribute("load");
                if (StringUtils.hasText((String)loadId)) {
                    beanBuilder.addPropertyValue("id", (Object)Long.parseLong(loadId));
                }
                Element tnxMng = DomUtils.getChildElementByTagName((Element)persistenceElm, (String)TX_MANAGER_ATTRIBUTE);
                String ref = tnxMng.getAttribute("ref");
                beanBuilder.addPropertyReference("platformTransactionManager", ref);
                Element emf = DomUtils.getChildElementByTagName((Element)persistenceElm, (String)EMF_ATTRIBUTE);
                ref = emf.getAttribute("ref");
                beanBuilder.addPropertyReference("entityManagerFactory", ref);
                Element variablePersisters = DomUtils.getChildElementByTagName((Element)persistenceElm, (String)"variable-persisters");
                if (variablePersisters != null && variablePersisters.hasChildNodes()) {
                    List childPersisterElems = DomUtils.getChildElementsByTagName((Element)variablePersisters, (String)"persister");
                    ManagedMap persistors = new ManagedMap(childPersisterElems.size());
                    for (Element persisterElem : childPersisterElems) {
                        String forClass = persisterElem.getAttribute(FORCLASS_ATTRIBUTE);
                        String implementation = persisterElem.getAttribute(IMPLEMENTATION_ATTRIBUTE);
                        if (!StringUtils.hasText((String)forClass)) {
                            throw new RuntimeException("persister element must have valid for-class attribute");
                        }
                        if (!StringUtils.hasText((String)implementation)) {
                            throw new RuntimeException("persister element must have valid implementation attribute");
                        }
                        persistors.put((Object)forClass, (Object)implementation);
                    }
                    beanBuilder.addPropertyValue("variablePersisters", (Object)persistors);
                }
                factory.addPropertyValue("jpaConfiguration", (Object)beanBuilder.getBeanDefinition());
            }
            BeanDefinitionBuilder rbaseConfBuilder = BeanDefinitionBuilder.rootBeanDefinition(SessionConfiguration.class);
            Element e = DomUtils.getChildElementByTagName((Element)ksessionConf, (String)KEEP_REFERENCE);
            if (e != null && StringUtils.hasText((String)e.getAttribute("enabled"))) {
                rbaseConfBuilder.addPropertyValue("keepReference", (Object)Boolean.parseBoolean(e.getAttribute("enabled")));
            }
            if ((e = DomUtils.getChildElementByTagName((Element)ksessionConf, (String)CLOCK_TYPE)) != null && StringUtils.hasText((String)e.getAttribute(TYPE_ATTRIBUTE))) {
                rbaseConfBuilder.addPropertyValue("clockType", (Object)ClockType.resolveClockType((String)e.getAttribute(TYPE_ATTRIBUTE)));
            }
            factory.addPropertyValue("conf", (Object)rbaseConfBuilder.getBeanDefinition());
            e = DomUtils.getChildElementByTagName((Element)ksessionConf, (String)WORK_ITEMS);
            if (e != null && (children = DomUtils.getChildElementsByTagName((Element)e, (String)WORK_ITEM)) != null && !children.isEmpty()) {
                ManagedMap workDefs = new ManagedMap();
                for (Element child : children) {
                    workDefs.put((Object)child.getAttribute(NAME_ATTRIBUTE), (Object)new RuntimeBeanReference(child.getAttribute("ref")));
                }
                factory.addPropertyValue("workItems", (Object)workDefs);
            }
        }
        if ((batch = DomUtils.getChildElementByTagName((Element)element, (String)"batch")) == null) {
            batch = DomUtils.getChildElementByTagName((Element)element, (String)"script");
        }
        if (batch != null) {
            ManagedList children = new ManagedList();
            int length = batch.getChildNodes().getLength();
            for (int i = 0; i < length; ++i) {
                Element nestedElm;
                String ref;
                Node n = batch.getChildNodes().item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                BeanDefinitionBuilder beanBuilder = null;
                if ("insert-object".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    nestedElm = this.getFirstElement(e.getChildNodes());
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(InsertObjectCommand.class);
                    if (StringUtils.hasText((String)ref)) {
                        beanBuilder.addConstructorArgReference(ref);
                    } else {
                        if (nestedElm == null) throw new IllegalArgumentException("insert-object must either specify a 'ref' attribute or have a nested bean");
                        beanBuilder.addConstructorArgValue(parserContext.getDelegate().parsePropertySubElement(nestedElm, null, null));
                    }
                } else if ("set-global".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    nestedElm = this.getFirstElement(e.getChildNodes());
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(SetGlobalCommand.class);
                    beanBuilder.addConstructorArgValue((Object)e.getAttribute("identifier"));
                    if (StringUtils.hasText((String)ref)) {
                        beanBuilder.addConstructorArgReference(ref);
                    } else {
                        if (nestedElm == null) throw new IllegalArgumentException("set-global must either specify a 'ref' attribute or have a nested bean");
                        beanBuilder.addConstructorArgValue(parserContext.getDelegate().parsePropertySubElement(nestedElm, null, null));
                    }
                } else if ("fire-until-halt".equals(e.getLocalName())) {
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FireUntilHaltCommand.class);
                } else if ("fire-all-rules".equals(e.getLocalName())) {
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FireAllRulesCommand.class);
                    String max = e.getAttribute("max");
                    if (StringUtils.hasText((String)max)) {
                        beanBuilder.addPropertyValue("max", (Object)max);
                    }
                } else if ("start-process".equals(e.getLocalName())) {
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(StartProcessCommand.class);
                    String processId = e.getAttribute("process-id");
                    if (!StringUtils.hasText((String)processId)) {
                        throw new IllegalArgumentException("start-process must specify a process-id");
                    }
                    beanBuilder.addConstructorArgValue((Object)processId);
                    List params = DomUtils.getChildElementsByTagName((Element)e, (String)"parameter");
                    if (!params.isEmpty()) {
                        ManagedMap map = new ManagedMap();
                        for (Element param : params) {
                            String identifier = param.getAttribute("identifier");
                            if (!StringUtils.hasText((String)identifier)) {
                                throw new IllegalArgumentException("start-process paramaters must specify an identifier");
                            }
                            String ref2 = param.getAttribute("ref");
                            Element nestedElm2 = this.getFirstElement(param.getChildNodes());
                            if (StringUtils.hasText((String)ref2)) {
                                map.put((Object)identifier, (Object)new RuntimeBeanReference(ref2));
                                continue;
                            }
                            if (nestedElm2 == null) throw new IllegalArgumentException("start-process parameters must either specify a 'ref' attribute or have a nested bean");
                            map.put((Object)identifier, parserContext.getDelegate().parsePropertySubElement(nestedElm2, null, null));
                        }
                        beanBuilder.addPropertyValue("parameters", (Object)map);
                    }
                } else if ("signal-event".equals(e.getLocalName())) {
                    beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(SignalEventCommand.class);
                    String processInstanceId = e.getAttribute("process-instance-id");
                    if (StringUtils.hasText((String)processInstanceId)) {
                        beanBuilder.addConstructorArgValue((Object)processInstanceId);
                    }
                    beanBuilder.addConstructorArgValue((Object)e.getAttribute("event-type"));
                    String ref3 = e.getAttribute("ref");
                    Element nestedElm3 = this.getFirstElement(e.getChildNodes());
                    if (StringUtils.hasText((String)ref3)) {
                        beanBuilder.addConstructorArgReference(ref3);
                    } else {
                        if (nestedElm3 == null) throw new IllegalArgumentException("signal-event must either specify a 'ref' attribute or have a nested bean");
                        beanBuilder.addConstructorArgValue(parserContext.getDelegate().parsePropertySubElement(nestedElm3, null, null));
                    }
                }
                if (beanBuilder == null) {
                    throw new IllegalStateException("Unknow element: " + e.getLocalName());
                }
                children.add((Object)beanBuilder.getBeanDefinition());
            }
            factory.addPropertyValue("batch", (Object)children);
        }
        if (!sessionType.equals("stateless")) return factory.getBeanDefinition();
        for (String beanName : parserContext.getRegistry().getBeanDefinitionNames()) {
            PropertyValue pvalue;
            RuntimeBeanReference tbf;
            BeanDefinition def = parserContext.getRegistry().getBeanDefinition(beanName);
            if (!KnowledgeAgentBeanFactory.class.getName().equals(def.getBeanClassName()) || !kbase.equals((tbf = (RuntimeBeanReference)(pvalue = def.getPropertyValues().getPropertyValue(KBASE_ATTRIBUTE)).getValue()).getBeanName())) continue;
            factory.addPropertyValue("knowledgeAgent", (Object)new RuntimeBeanReference(beanName));
        }
        return factory.getBeanDefinition();
    }

    private Element getFirstElement(NodeList list) {
        int lengthj = list.getLength();
        for (int j = 0; j < lengthj; ++j) {
            if (!(list.item(j) instanceof Element)) continue;
            return (Element)list.item(j);
        }
        return null;
    }
}

