/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import org.drools.container.spring.beans.KnowledgeLoggerAdaptor;
import org.drools.container.spring.beans.KnowledgeLoggerBeanFactory;
import org.drools.container.spring.namespace.DefinitionParserHelper;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class KnowledgeLoggerDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String LOGGER_ATTRIBUTE_FILE = "file";
    public static final String LOGGER_ATTRIBUTE_ID = "id";
    public static final String LOGGER_ATTRIBUTE_THREADED = "threaded";
    public static final String LOGGER_ATTRIBUTE_LOGGER_TYPE = "loggerType";
    public static final String LOGGER_ATTRIBUTE_INTERVAL = "interval";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(KnowledgeLoggerBeanFactory.class);
        String id = element.getAttribute(LOGGER_ATTRIBUTE_ID);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), LOGGER_ATTRIBUTE_ID, id);
        factory.addPropertyValue("name", (Object)id);
        if ("fileLogger".equalsIgnoreCase(element.getLocalName())) {
            String threadedStr;
            String fileName = element.getAttribute(LOGGER_ATTRIBUTE_FILE);
            DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), LOGGER_ATTRIBUTE_FILE, fileName);
            if (StringUtils.hasText((String)fileName)) {
                factory.addPropertyValue(LOGGER_ATTRIBUTE_FILE, (Object)fileName);
            }
            if ((threadedStr = element.getAttribute(LOGGER_ATTRIBUTE_THREADED)) != null && Boolean.valueOf(threadedStr).booleanValue()) {
                factory.addPropertyValue(LOGGER_ATTRIBUTE_LOGGER_TYPE, (Object)KnowledgeLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_THREADED_FILE);
                String intervalStr = element.getAttribute(LOGGER_ATTRIBUTE_INTERVAL);
                if (intervalStr != null) {
                    try {
                        int interval = Integer.parseInt(intervalStr);
                        factory.addPropertyValue(LOGGER_ATTRIBUTE_INTERVAL, (Object)interval);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Interval attribute must be of type integer for bean '" + id + "'");
                    }
                }
            } else {
                factory.addPropertyValue(LOGGER_ATTRIBUTE_LOGGER_TYPE, (Object)KnowledgeLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_FILE);
            }
        } else if ("consoleLogger".equalsIgnoreCase(element.getLocalName())) {
            factory.addPropertyValue(LOGGER_ATTRIBUTE_LOGGER_TYPE, (Object)KnowledgeLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_CONSOLE);
        }
        return factory.getBeanDefinition();
    }
}

