/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.container.spring.beans.KnowledgeLoggerAdaptor;
import org.drools.grid.GridNode;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.logger.KnowledgeRuntimeLogger;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NamedBean;
import org.springframework.beans.factory.support.ManagedList;

public abstract class AbstractKnowledgeSessionBeanFactory
implements FactoryBean,
InitializingBean,
BeanNameAware,
NamedBean {
    private GridNode node;
    private Map<String, WorkItemHandler> workItems;
    private KieSessionConfiguration conf;
    private KieBase kbase;
    private String beanName;
    private String name;
    private List<Command<?>> batch;
    protected List<AgendaEventListener> agendaEventListeners;
    protected List<ProcessEventListener> processEventListeners;
    protected List<RuleRuntimeEventListener> workingMemoryEventListeners;
    protected List<Object> groupedListeners = new ArrayList<Object>();
    protected ManagedList<KnowledgeLoggerAdaptor> loggerAdaptors = new ManagedList();

    public AbstractKnowledgeSessionBeanFactory() {
        this.agendaEventListeners = new ArrayList<AgendaEventListener>();
        this.processEventListeners = new ArrayList<ProcessEventListener>();
        this.workingMemoryEventListeners = new ArrayList<RuleRuntimeEventListener>();
    }

    public Object getObject() throws Exception {
        return this.getCommandExecutor();
    }

    public Map<String, WorkItemHandler> getWorkItems() {
        return this.workItems;
    }

    public void setWorkItems(Map<String, WorkItemHandler> workItems) {
        this.workItems = workItems;
    }

    public KieSessionConfiguration getConf() {
        return this.conf;
    }

    public void setConf(KieSessionConfiguration conf) {
        this.conf = conf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KieBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KieBase kbase) {
        this.kbase = kbase;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<Command<?>> getBatch() {
        return this.batch;
    }

    public void setBatch(List<Command<?>> commands) {
        this.batch = commands;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.kbase == null) {
            throw new IllegalArgumentException("kbase property is mandatory");
        }
        if (this.name == null) {
            this.name = this.beanName;
        }
        this.internalAfterPropertiesSet();
    }

    protected abstract CommandExecutor getCommandExecutor();

    protected abstract void internalAfterPropertiesSet();

    public GridNode getNode() {
        return this.node;
    }

    public void setNode(GridNode node) {
        this.node = node;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setEventListenersFromGroup(List<Object> eventListenerList) {
        for (Object eventListener : eventListenerList) {
            if (eventListener instanceof AgendaEventListener) {
                this.agendaEventListeners.add((AgendaEventListener)eventListener);
            }
            if (eventListener instanceof RuleRuntimeEventListener) {
                this.workingMemoryEventListeners.add((RuleRuntimeEventListener)eventListener);
            }
            if (!(eventListener instanceof ProcessEventListener)) continue;
            this.processEventListeners.add((ProcessEventListener)eventListener);
        }
        this.groupedListeners.addAll(eventListenerList);
    }

    public void setEventListeners(Map<String, List> eventListenerMap) {
        for (Map.Entry<String, List> entry : eventListenerMap.entrySet()) {
            String key = entry.getKey();
            List eventListenerList = entry.getValue();
            if ("agenda-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof AgendaEventListener) {
                        this.agendaEventListeners.add((AgendaEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The agendaEventListener (" + eventListener.getClass() + ") is not an instance of " + AgendaEventListener.class);
                }
                continue;
            }
            if ("working-memory-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof RuleRuntimeEventListener) {
                        this.workingMemoryEventListeners.add((RuleRuntimeEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The workingMemoryEventListener (" + eventListener.getClass() + ") is not an instance of " + RuleRuntimeEventListener.class);
                }
                continue;
            }
            if (!"process-event-listener".equalsIgnoreCase(key)) continue;
            for (Object eventListener : eventListenerList) {
                if (eventListener instanceof ProcessEventListener) {
                    this.processEventListeners.add((ProcessEventListener)eventListener);
                    continue;
                }
                throw new IllegalArgumentException("The processEventListener (" + eventListener.getClass() + ") is not an instance of " + ProcessEventListener.class);
            }
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventListeners;
    }

    public void setAgendaEventListeners(List<AgendaEventListener> agendaEventListeners) {
        this.agendaEventListeners = agendaEventListeners;
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventListeners;
    }

    public void setProcessEventListeners(List<ProcessEventListener> processEventListeners) {
        this.processEventListeners = processEventListeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.workingMemoryEventListeners;
    }

    public void setWorkingMemoryEventListeners(List<RuleRuntimeEventListener> workingMemoryEventListeners) {
        this.workingMemoryEventListeners = workingMemoryEventListeners;
    }

    public List<KnowledgeLoggerAdaptor> getKnowledgeRuntimeLoggers() {
        return this.loggerAdaptors;
    }

    public void setKnowledgeRuntimeLoggers(List<KnowledgeLoggerAdaptor> loggers) {
        this.loggerAdaptors.addAll(loggers);
    }

    protected void attachLoggers(KieRuntimeEventManager ksession) {
        if (this.loggerAdaptors != null && this.loggerAdaptors.size() > 0) {
            for (KnowledgeLoggerAdaptor adaptor : this.loggerAdaptors) {
                switch (adaptor.getLoggerType()) {
                    case LOGGER_TYPE_FILE: {
                        KnowledgeRuntimeLogger runtimeLogger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession), (String)adaptor.getFile());
                        adaptor.setRuntimeLogger((KieRuntimeLogger)runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_THREADED_FILE: {
                        KnowledgeRuntimeLogger runtimeLogger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession), (String)adaptor.getFile(), (int)adaptor.getInterval());
                        adaptor.setRuntimeLogger((KieRuntimeLogger)runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_CONSOLE: {
                        KnowledgeRuntimeLogger runtimeLogger = KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession));
                        adaptor.setRuntimeLogger((KieRuntimeLogger)runtimeLogger);
                    }
                }
            }
        }
    }
}

