/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.session.JpaManager;
import org.drools.runtime.Environment;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DroolsSpringJpaManager
implements JpaManager {
    Environment env;
    private EntityManagerFactory emf;
    private EntityManager appScopedEntityManager;
    private boolean internalAppScopedEntityManager;

    public DroolsSpringJpaManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.getApplicationScopedEntityManager();
    }

    public EntityManager getApplicationScopedEntityManager() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.emf);
                if (emHolder == null) {
                    this.appScopedEntityManager = this.emf.createEntityManager();
                    emHolder = new EntityManagerHolder(this.appScopedEntityManager);
                    TransactionSynchronizationManager.bindResource((Object)this.emf, (Object)emHolder);
                } else {
                    this.appScopedEntityManager = emHolder.getEntityManager();
                }
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", (Object)emHolder.getEntityManager());
                this.internalAppScopedEntityManager = true;
            }
        }
        return this.appScopedEntityManager;
    }

    public EntityManager getCommandScopedEntityManager() {
        return this.getApplicationScopedEntityManager();
    }

    public void beginCommandScopedEntityManager() {
        this.env.set("drools.persistence.jpa.CmdScopedEntityManager", (Object)this.appScopedEntityManager);
    }

    public void endCommandScopedEntityManager() {
        this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
    }

    public void dispose() {
        if (this.internalAppScopedEntityManager) {
            TransactionSynchronizationManager.unbindResource((Object)this.emf);
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
                this.internalAppScopedEntityManager = false;
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", null);
                this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
            }
        }
    }
}

