/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import org.drools.container.spring.beans.persistence.SpringTransactionSynchronizationAdapter;
import org.drools.persistence.session.TransactionManager;
import org.drools.persistence.session.TransactionSynchronization;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DroolsSpringTransactionManager
implements TransactionManager {
    private AbstractPlatformTransactionManager ptm;
    TransactionDefinition td = new DefaultTransactionDefinition();
    TransactionStatus currentTransaction = null;
    private boolean localTransaction;

    public DroolsSpringTransactionManager(AbstractPlatformTransactionManager ptm) {
        this.ptm = ptm;
    }

    public void begin() {
        if (this.getStatus() == 3) {
            this.currentTransaction = this.ptm.getTransaction(this.td);
            this.localTransaction = true;
        } else {
            this.localTransaction = false;
        }
    }

    public void commit() {
        if (this.localTransaction) {
            this.localTransaction = false;
            this.ptm.commit(this.currentTransaction);
        }
    }

    public void rollback() {
        this.localTransaction = false;
        this.ptm.rollback(this.currentTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        if (this.ptm == null) {
            return 3;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionStatus transaction = null;
            try {
                if (this.currentTransaction == null) {
                    transaction = this.ptm.getTransaction(this.td);
                    if (transaction.isNewTransaction()) {
                        int n = 0;
                        return n;
                    }
                } else {
                    transaction = this.currentTransaction;
                }
                if (transaction.isCompleted()) {
                    if (transaction.isRollbackOnly()) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                if (transaction.isRollbackOnly()) {
                    int n = 1;
                    return n;
                }
                int n = 4;
                return n;
            }
            finally {
                if (this.currentTransaction == null) {
                    this.ptm.commit(transaction);
                }
            }
        }
        return 3;
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        TransactionSynchronizationManager.registerSynchronization((org.springframework.transaction.support.TransactionSynchronization)new SpringTransactionSynchronizationAdapter(ts));
    }
}

