/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.JPAKnowledgeFactoryService;
import org.drools.grid.ExecutionNode;
import org.drools.grid.local.LocalConnection;
import org.drools.persistence.processinstance.VariablePersistenceStrategyFactory;
import org.drools.persistence.processinstance.persisters.VariablePersister;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAKnowledgeServiceBean
extends JpaDaoSupport {
    private ExecutionNode node;
    private KnowledgeBase kbase;
    private JPAKnowledgeFactoryService jpaKnowledgeServiceProvider;
    private Environment environment;
    private AbstractPlatformTransactionManager transactionManager;
    private Map<Class<?>, Class<? extends VariablePersister>> variablePersisters = Collections.emptyMap();

    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        TransactionTemplate txTemplate = new TransactionTemplate((PlatformTransactionManager)this.transactionManager);
        return (StatefulKnowledgeSession)txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return JPAKnowledgeServiceBean.this.getJpaTemplate().execute(new JpaCallback(){

                    public StatefulKnowledgeSession doInJpa(EntityManager em) throws PersistenceException {
                        return JPAKnowledgeServiceBean.this.jpaKnowledgeServiceProvider.newStatefulKnowledgeSession(JPAKnowledgeServiceBean.this.kbase, null, JPAKnowledgeServiceBean.this.environment);
                    }
                });
            }
        });
    }

    public StatefulKnowledgeSession loadStatefulKnowledgeSession(final int sessionId) {
        TransactionTemplate txTemplate = new TransactionTemplate((PlatformTransactionManager)this.transactionManager);
        return (StatefulKnowledgeSession)txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return JPAKnowledgeServiceBean.this.getJpaTemplate().execute(new JpaCallback(){

                    public StatefulKnowledgeSession doInJpa(EntityManager em) throws PersistenceException {
                        return JPAKnowledgeServiceBean.this.jpaKnowledgeServiceProvider.loadStatefulKnowledgeSession(sessionId, JPAKnowledgeServiceBean.this.kbase, null, JPAKnowledgeServiceBean.this.environment);
                    }
                });
            }
        });
    }

    protected void initDao() {
        if (this.kbase == null) {
            throw new IllegalArgumentException("property kbase is mandatory");
        }
        if (this.node == null) {
            LocalConnection connection = new LocalConnection();
            this.node = connection.getExecutionNode(null);
        }
        if (this.environment == null) {
            this.environment = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newEnvironment();
        }
        if (this.environment.get("drools.persistence.jpa.EntityManagerFactory") != null) {
            this.logger.debug((Object)"overwriting environment key: drools.persistence.jpa.EntityManagerFactory");
        }
        this.environment.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.getJpaTemplate().getEntityManagerFactory());
        if (this.environment.get("drools.transaction.TransactionManager") != null) {
            this.logger.debug((Object)"overwriting environment key: drools.transaction.TransactionManager");
        }
        this.environment.set("drools.transaction.TransactionManager", (Object)this.getTransactionManager());
        this.environment.set("drools.Globals", (Object)new MapGlobalResolver());
        if (this.variablePersisters != null && !this.variablePersisters.isEmpty()) {
            for (Map.Entry<Class<?>, Class<VariablePersister>> entry : this.variablePersisters.entrySet()) {
                VariablePersistenceStrategyFactory.getVariablePersistenceStrategy().setPersister(entry.getKey().getName(), entry.getValue().getName());
            }
        }
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public ExecutionNode getExecutionNode() {
        return this.node;
    }

    public void setExecutionNode(ExecutionNode node) {
        this.node = node;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public AbstractPlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setVariablePersisters(Map<Class<?>, Class<? extends VariablePersister>> variablePersisters) {
        this.variablePersisters = variablePersisters;
    }

    public Map<Class<?>, Class<? extends VariablePersister>> getVariablePersisters() {
        return this.variablePersisters;
    }
}

