/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.command.SingleSessionCommandService;
import org.drools.container.spring.beans.JPASingleSessionCommandService;
import org.drools.container.spring.beans.persistence.SpringSingleSessionCommandService;
import org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.drools.persistence.processinstance.JPASignalManagerFactory;
import org.drools.persistence.processinstance.JPAWorkItemManagerFactory;
import org.drools.persistence.processinstance.VariablePersistenceStrategyFactory;
import org.drools.persistence.processinstance.persisters.VariablePersister;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPASingleSessionCommandServiceFactory
implements FactoryBean,
InitializingBean {
    private Environment environment;
    private KnowledgeBase knowledgeBase;
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private Map<String, Class<? extends VariablePersister>> variablePersisters;

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Map<String, Class<? extends VariablePersister>> getVariablePersisters() {
        if (this.variablePersisters == null) {
            this.variablePersisters = new HashMap<String, Class<? extends VariablePersister>>();
        }
        return this.variablePersisters;
    }

    public void setVariablePersisters(Map<String, Class<? extends VariablePersister>> variablePersisters) {
        this.variablePersisters = variablePersisters;
    }

    public Object getObject() throws Exception {
        return new JPASessionService(this.getEnvironment(), this.getKnowledgeBase(), this.getEntityManagerFactory(), this.getTransactionManager());
    }

    public Class<JPASingleSessionCommandService> getObjectType() {
        return JPASingleSessionCommandService.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getEnvironment() == null) {
            this.setEnvironment(KnowledgeBaseFactory.newEnvironment());
        }
        if (this.getTransactionManager() == null) {
            throw new IllegalArgumentException("transactionManager property is mandatory");
        }
        if (this.getEntityManagerFactory() == null) {
            throw new IllegalArgumentException("entityManagerFactory property is mandatory");
        }
        if (this.getKnowledgeBase() == null) {
            throw new IllegalArgumentException("knowledgeBase property is mandatory");
        }
        if (!this.getVariablePersisters().isEmpty()) {
            for (Map.Entry<String, Class<? extends VariablePersister>> entry : this.getVariablePersisters().entrySet()) {
                VariablePersistenceStrategyFactory.getVariablePersistenceStrategy().setPersister(entry.getKey(), entry.getValue().getName());
            }
        }
    }

    private static class JPASessionService
    implements JPASingleSessionCommandService {
        private Environment environment;
        private KnowledgeBase knowledgeBase;
        private EntityManagerFactory entityManagerFactory;
        private PlatformTransactionManager transactionManager;

        public JPASessionService(Environment environment, KnowledgeBase knowledgeBase, EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager) {
            this.environment = environment;
            this.knowledgeBase = knowledgeBase;
            this.entityManagerFactory = entityManagerFactory;
            this.transactionManager = transactionManager;
        }

        public SingleSessionCommandService newStatefulKnowledgeSession() {
            return new SpringSingleSessionCommandService(this.knowledgeBase, (KnowledgeSessionConfiguration)this.getSessionConfiguration(), this.getEnvironment());
        }

        public SingleSessionCommandService loadStatefulKnowledgeSession(int sessionId) {
            return new SpringSingleSessionCommandService(sessionId, this.knowledgeBase, (KnowledgeSessionConfiguration)this.getSessionConfiguration(), this.getEnvironment());
        }

        public Environment getEnvironment() {
            this.environment.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.entityManagerFactory);
            this.environment.set("drools.persistence.jpa.TransactionManager", (Object)this.transactionManager);
            return this.environment;
        }

        private SessionConfiguration getSessionConfiguration() {
            Properties properties = new Properties();
            properties.setProperty("drools.commandService", SpringSingleSessionCommandService.class.getName());
            properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
            properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
            properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
            return new SessionConfiguration(properties);
        }
    }
}

