/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.grid.ExecutionNode;
import org.drools.grid.local.LocalConnection;
import org.drools.io.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBaseBeanFactory
implements FactoryBean,
InitializingBean {
    private KnowledgeBase kbase;
    private ExecutionNode node;
    private List<DroolsResourceAdapter> resources = Collections.emptyList();
    private List<DroolsResourceAdapter> models = Collections.emptyList();

    public Object getObject() throws Exception {
        return this.kbase;
    }

    public Class<? extends KnowledgeBase> getObjectType() {
        return KnowledgeBase.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.node == null) {
            this.node = new LocalConnection().getExecutionNode();
        }
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        this.kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        if (this.models != null && this.models.size() > 0) {
            for (DroolsResourceAdapter res : this.models) {
                Options xjcOptions = new Options();
                xjcOptions.setSchemaLanguage(Language.XMLSCHEMA);
                try {
                    KnowledgeBuilderHelper.addXsdModel((Resource)res.getDroolsResource(), (KnowledgeBuilder)kbuilder, (Options)xjcOptions, (String)"xsd");
                    this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error creating XSD model", e);
                }
            }
        }
        for (DroolsResourceAdapter res : this.resources) {
            if (res.getResourceConfiguration() == null) {
                kbuilder.add(res.getDroolsResource(), res.getResourceType());
                continue;
            }
            kbuilder.add(res.getDroolsResource(), res.getResourceType(), res.getResourceConfiguration());
        }
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors.toString());
        }
        this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public ExecutionNode getNode() {
        return this.node;
    }

    public List<DroolsResourceAdapter> getResources() {
        return this.resources;
    }

    public void setResources(List<DroolsResourceAdapter> resources) {
        this.resources = resources;
    }

    public void setNode(ExecutionNode executionNode) {
        this.node = executionNode;
    }

    public void setModels(List<DroolsResourceAdapter> models) {
        this.models = models;
    }

    public List<DroolsResourceAdapter> getModels() {
        return this.models;
    }
}

