/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.PackageScanClassResolver;
import org.drools.server.KnowledgeService;
import org.drools.server.KnowledgeServiceImpl;
import org.drools.server.profile.KnowledgeServiceConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeServiceBeanFactory
implements FactoryBean,
InitializingBean {
    private String id;
    private CamelContext camelContext;
    private PackageScanClassResolver packageClassLoaderResolver;
    private KnowledgeService service;
    private List<KnowledgeServiceConfiguration> configurations = Collections.emptyList();
    private String nodeId;

    public Object getObject() throws Exception {
        return this.service;
    }

    public Class<? extends KnowledgeService> getObjectType() {
        return KnowledgeService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, KnowledgeServiceConfiguration> configs = new HashMap<String, KnowledgeServiceConfiguration>();
        for (KnowledgeServiceConfiguration cfg : this.configurations) {
            configs.put(cfg.getSessionId(), cfg);
        }
        this.service = new KnowledgeServiceImpl(this.camelContext, configs, this.nodeId);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setService(KnowledgeService service) {
        this.service = service;
    }

    public KnowledgeService getService() {
        return this.service;
    }

    public void setConfigurations(List<KnowledgeServiceConfiguration> configurations) {
        this.configurations = configurations;
    }

    public List<KnowledgeServiceConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setPackageClassLoaderResolver(PackageScanClassResolver packageClassLoaderResolver) {
        this.packageClassLoaderResolver = packageClassLoaderResolver;
    }

    public PackageScanClassResolver getPackageClassLoaderResolver() {
        return this.packageClassLoaderResolver;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

