/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.command.CommandService;
import org.drools.command.Context;
import org.drools.command.SingleSessionCommandService;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.AbstractWorkingMemory;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.persistence.processinstance.JPAProcessInstanceManager;
import org.drools.persistence.processinstance.JPASignalManager;
import org.drools.persistence.processinstance.JPAWorkItemManager;
import org.drools.persistence.session.JPASessionMarshallingHelper;
import org.drools.persistence.session.SessionInfo;
import org.drools.persistence.session.SingleSessionCommandService;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSingleSessionCommandService
implements SingleSessionCommandService {
    private JpaTemplate jpaTemplate;
    private SessionInfo sessionInfo;
    private JPASessionMarshallingHelper marshallingHelper;
    private StatefulKnowledgeSession ksession;
    private Environment env;
    private KnowledgeCommandContext kContext;
    private PlatformTransactionManager transactionManager;

    private void checkEnvironment(Environment env) {
        if (env.get("drools.persistence.jpa.EntityManagerFactory") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory");
        }
        this.env = env;
        this.transactionManager = (PlatformTransactionManager)env.get("drools.persistence.jpa.TransactionManager");
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("Environment must have an TransactionManager");
        }
    }

    public SpringSingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this((KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SpringSingleSessionCommandService(int sessionId, RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this(sessionId, (KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SpringSingleSessionCommandService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.checkEnvironment(env);
        this.sessionInfo = new SessionInfo();
        ReteooStatefulSession session = (ReteooStatefulSession)((KnowledgeBaseImpl)kbase).ruleBase.newStatefulSession((SessionConfiguration)conf, this.env);
        this.ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)session, kbase);
        this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, this.ksession, null);
        ((JPASignalManager)((StatefulKnowledgeSessionImpl)this.ksession).session.getSignalManager()).setCommandService((CommandService)this);
        this.marshallingHelper = new JPASessionMarshallingHelper(this.ksession, conf);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        TransactionTemplate txTemplate = new TransactionTemplate(this.transactionManager);
        this.jpaTemplate = new JpaTemplate((EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory"));
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                Object result = SpringSingleSessionCommandService.this.jpaTemplate.execute(new JpaCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInJpa(EntityManager em) throws PersistenceException {
                        try {
                            SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", (Object)em);
                            em.persist((Object)SpringSingleSessionCommandService.this.sessionInfo);
                            ((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.setId(SpringSingleSessionCommandService.this.sessionInfo.getId());
                            ((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.setEndOperationListener((AbstractWorkingMemory.EndOperationListener)new SingleSessionCommandService.EndOperationListenerImpl(SpringSingleSessionCommandService.this.sessionInfo));
                            em.flush();
                            Object var2_2 = null;
                            return var2_2;
                        }
                        finally {
                            SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", null);
                        }
                    }
                });
                return result;
            }
        });
    }

    public SpringSingleSessionCommandService(final int sessionId, final KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        final KnowledgeSessionConfiguration localConf = conf == null ? new SessionConfiguration() : conf;
        this.env = env;
        this.checkEnvironment(env);
        TransactionTemplate txTemplate = new TransactionTemplate(this.transactionManager);
        this.jpaTemplate = new JpaTemplate((EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory"));
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return SpringSingleSessionCommandService.this.jpaTemplate.execute(new JpaCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInJpa(EntityManager em) throws PersistenceException {
                        try {
                            SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", (Object)em);
                            SpringSingleSessionCommandService.this.sessionInfo = (SessionInfo)em.find(SessionInfo.class, (Object)sessionId);
                            if (SpringSingleSessionCommandService.this.sessionInfo == null) {
                                SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", null);
                                throw new RuntimeException("Could not find session data for id " + sessionId);
                            }
                            SpringSingleSessionCommandService.this.marshallingHelper = new JPASessionMarshallingHelper(SpringSingleSessionCommandService.this.sessionInfo, kbase, localConf, SpringSingleSessionCommandService.this.env);
                            SpringSingleSessionCommandService.this.sessionInfo.setJPASessionMashallingHelper(SpringSingleSessionCommandService.this.marshallingHelper);
                            SpringSingleSessionCommandService.this.ksession = SpringSingleSessionCommandService.this.marshallingHelper.getObject();
                            SpringSingleSessionCommandService.this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, SpringSingleSessionCommandService.this.ksession, null);
                            ((JPASignalManager)((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.getSignalManager()).setCommandService((CommandService)SpringSingleSessionCommandService.this);
                            ((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.setId(SpringSingleSessionCommandService.this.sessionInfo.getId());
                            ((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.setEndOperationListener((AbstractWorkingMemory.EndOperationListener)new SingleSessionCommandService.EndOperationListenerImpl(SpringSingleSessionCommandService.this.sessionInfo));
                            em.flush();
                            SessionInfo sessionInfo = SpringSingleSessionCommandService.this.sessionInfo;
                            return sessionInfo;
                        }
                        finally {
                            SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", null);
                        }
                    }
                });
            }
        });
    }

    public Context getContext() {
        return this.kContext;
    }

    public synchronized <T> T execute(final GenericCommand<T> command) {
        this.ksession.halt();
        TransactionTemplate txTemplate = new TransactionTemplate(this.transactionManager);
        Object result = txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                Object result = SpringSingleSessionCommandService.this.jpaTemplate.execute(new JpaCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInJpa(EntityManager em) {
                        SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", (Object)em);
                        try {
                            SessionInfo sessionInfoMerged = (SessionInfo)em.merge((Object)SpringSingleSessionCommandService.this.sessionInfo);
                            sessionInfoMerged.setJPASessionMashallingHelper(SpringSingleSessionCommandService.this.sessionInfo.getJPASessionMashallingHelper());
                            SpringSingleSessionCommandService.this.sessionInfo = sessionInfoMerged;
                            ((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.setEndOperationListener((AbstractWorkingMemory.EndOperationListener)new SingleSessionCommandService.EndOperationListenerImpl(SpringSingleSessionCommandService.this.sessionInfo));
                            Object result = command.execute((Context)SpringSingleSessionCommandService.this.kContext);
                            em.flush();
                            Object object = result;
                            return object;
                        }
                        finally {
                            SpringSingleSessionCommandService.this.env.set("drools.persistence.jpa.EntityManager", null);
                        }
                    }
                });
                ((JPAProcessInstanceManager)((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.getProcessInstanceManager()).clearProcessInstances();
                ((JPAWorkItemManager)((StatefulKnowledgeSessionImpl)((SpringSingleSessionCommandService)SpringSingleSessionCommandService.this).ksession).session.getWorkItemManager()).clearWorkItems();
                return result;
            }
        });
        return (T)result;
    }

    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    public int getSessionId() {
        return this.sessionInfo.getId();
    }
}

